/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "aiming_turret.h"

#include "weapon_manager.h"
#include "aim.h"
#include "world_entities/projectiles/projectile.h"

#include "model.h"

#include "animation3d.h"

#include "util/loading/factory.h"

CREATE_FACTORY(AimingTurret, CL_AIMING_TURRET);




/**
 *  standard constructor

   creates a new weapon
*/
AimingTurret::AimingTurret ()
    : Weapon(), target(this)
{
  this->init();
  this->loadModel("models/guns/turret2.obj");
}


AimingTurret::AimingTurret(const TiXmlElement* root)
    : target(this)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
AimingTurret::~AimingTurret ()
{
  // model will be deleted from WorldEntity-destructor
  //  delete this->target;
}

void AimingTurret::init()
{
  this->setClassID(CL_AIMING_TURRET, "AimingTurret");

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .9);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(10000);
  this->increaseEnergy(100000);

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET);
  this->setProjectileType(CL_GUIDED_MISSILE);


  this->setEmissionPoint(1.684, 0.472, 0);
  //this->getProjectileFactory()->prepare(100);

  this->target.addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT | PNODE_PROHIBIT_CHILD_DELETE);
  this->target.setVisibility(false);
  this->target.setRange(400);
  this->target.setAngle(M_PI_2);

  this->setActionSound(WA_SHOOT, "sound/explosions/explosion_3.wav");
  this->setActionSound(WA_ACTIVATE, "sound/voices/rockets.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");

}

void AimingTurret::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);

}

void AimingTurret::activate()
{
  this->target.setVisibility(true);
}

void AimingTurret::deactivate()
{
  this->target.setVisibility(false);
}

void AimingTurret::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;
  Quaternion quat;
  Vector direction = this->target.getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    //quat = Quaternion(direction, this->getParent()->getAbsDirY()) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
    quat = Quaternion ( M_PI_2, this->getParent()->getAbsDirY()) * Quaternion::lookAt(this->getAbsCoor(), this->target.getAbsCoor(), this->getParent()->getAbsDirY());
  else
    //quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
    quat = Quaternion ( M_PI_2, Vector(0,1,0)) * Quaternion::lookAt(this->getAbsCoor(), this->target.getAbsCoor(), Vector(0,1,0));

  this->setAbsDirSoft(quat, 5);

  this->target.tick(dt);
}

void AimingTurret::fire()
{
  Projectile* pj = this->getProjectile();
  if (pj == NULL)
    return;

  pj->setVelocity(/*this->getVelocity()+*/(this->getAbsDirX()*250.0 + VECTOR_RAND(4)
                                          /*target.getAbsCoor() - this->getAbsCoor()*/)*.5);//this->getVelocity());

  pj->setParent(PNode::getNullParent());
  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
}


/**
 * draws the AimingTurret
*/
void AimingTurret::draw () const
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  if (this->getModel())
    this->getModel()->draw();
  glPopMatrix();
}

