/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Benjamin Knecht
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDBoostBar_H__
#define _HUDBoostBar_H__

#include "overlays/OverlaysPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "HUDBar.h"

namespace orxonox
{
    class _OverlaysExport HUDBoostBar : public HUDBar, public Tickable
    {
    public:
        HUDBoostBar(Context* context);
        virtual ~HUDBoostBar();

        virtual void tick(float dt);
        virtual void changedOwner();

    private:
        SpaceShip*  owner_;
        float       flashInterval_;
        float       flashDt_;
    };
}
#endif /* _HUDBoostBar_H__ */
