/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Knecht
   co-programmer: Silvan Nellen

*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "executor/executor.h"
#include "space_ship.h"

#include "util/loading/resource_manager.h"

#include "weapons/test_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "dot_emitter.h"
#include "sprite_particles.h"

#include "util/loading/factory.h"
#include "key_mapper.h"

#include "network_game_manager.h"
#include "shared_network_data.h"

#include "power_ups/weapon_power_up.h"
#include "power_ups/param_power_up.h"

#include "graphics_engine.h"

#include "plane.h"

#include "state.h"
#include "player.h"

#include "util/loading/load_param.h"


// #include "lib/gui/gl_gui/glgui_bar.h"
// #include "lib/gui/gl_gui/glgui_pushbutton.h"




CREATE_FACTORY(SpaceShip, CL_SPACE_SHIP);
#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(SpaceShip, CL_SPACE_SHIP,
                        addMethod("hasPlayer", ExecutorLua0ret<Playable,bool>(&Playable::hasPlayer))
                        ->addMethod("fire", ExecutorLua1<Playable, bool>(&Playable::fire))
                        ->addMethod("loadModel", ExecutorLua2<WorldEntity,const std::string& ,float>(&WorldEntity::loadModel2))
                        ->addMethod("setName", ExecutorLua1<BaseObject,const std::string&>(&BaseObject::setName))
                        ->addMethod("hide", ExecutorLua0<WorldEntity>(&WorldEntity::hide))
                        ->addMethod("unhide", ExecutorLua0<WorldEntity>(&WorldEntity::unhide))
                       //Coordinates
                        ->addMethod("setAbsCoor", ExecutorLua3<PNode,float,float,float>(&PNode::setAbsCoor))
                        ->addMethod("getAbsCoorX", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorX))
                        ->addMethod("getAbsCoorY", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorY))
                        ->addMethod("getAbsCoorZ", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorZ))
                       );

/**
 *  destructs the spaceship, deletes alocated memory
 */
SpaceShip::~SpaceShip ()
{
  this->setPlayer(NULL);
}

/**
 * loads a Spaceships information from a specified file.
 * @param fileName the name of the File to load the spaceship from (absolute path)
 */
SpaceShip::SpaceShip(const std::string& fileName)
{
  this->init();
  TiXmlDocument doc(fileName);

  if(!doc.LoadFile())
  {
    PRINTF(2)("Loading file %s failed for spaceship.\n", fileName.c_str());
    return;
  }

  this->loadParams(doc.RootElement());
}

/**
 *  creates a new Spaceship from Xml Data
 * @param root the xml element containing spaceship data

   @todo add more parameters to load
*/
SpaceShip::SpaceShip(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);

}


/**
 * initializes a Spaceship
 */
void SpaceShip::init()
{
//  this->setRelDir(Quaternion(M_PI, Vector(1,0,0)));
  this->setClassID(CL_SPACE_SHIP, "SpaceShip");

  PRINTF(4)("SPACESHIP INIT\n");

  //weapons:
  Weapon* wpRight = new TestGun(0);
  wpRight->setName("testGun Right");
  Weapon* wpLeft = new TestGun(1);
  wpLeft->setName("testGun Left");
  //Weapon* cannon = dynamic_cast<Weapon*>(Factory::fabricate(CL_CANNON));

  //cannon->setName("BFG");

  this->addWeapon(wpLeft, 1, 0);
  this->addWeapon(wpRight,1 ,1);
  //this->addWeapon(cannon, 0, 6);

  this->getWeaponManager().changeWeaponConfig(1);

  bUp = bDown = bLeft = bRight = bAscend = bDescend = bRollL = bRollR = false;

  xMouse = yMouse = 0;
  yInvert = 1;
  mouseSensitivity = 0.001;
  airViscosity = 0.9;
  controlVelocityX = 25;
  controlVelocityY = 150;
  shipInertia = 1.5;
//  cycle = 0.0;

  this->setHealthMax(100);
  this->setHealth(80);

  travelSpeed = 0.0;
  acceleration = 3;
  this->velocity = this->getAbsDirX()*travelSpeed;
  this->mouseDir = this->getAbsDir();
  this->pitchDir = this->getAbsDir();

//   GLGuiButton* button = new GLGuiPushButton();
//    button->show();
//    button->setLabel("orxonox");
//    button->setBindNode(this);
//     GLGuiBar* bar = new GLGuiBar();
//     bar->show();
//     bar->setValue(7.0);
//     bar->setMaximum(10);
//     bar->setSize2D( 20, 100);
//     bar->setAbsCoor2D( 10, 200);

  //add events to the eventlist
  registerEvent(KeyMapper::PEV_FORWARD);
  registerEvent(KeyMapper::PEV_BACKWARD);
  registerEvent(KeyMapper::PEV_LEFT);
  registerEvent(KeyMapper::PEV_RIGHT);
  //registerEvent(SDLK_q);
  //registerEvent(SDLK_e);
  registerEvent(KeyMapper::PEV_FIRE1);
  registerEvent(KeyMapper::PEV_NEXT_WEAPON);
  registerEvent(KeyMapper::PEV_PREVIOUS_WEAPON);
  //registerEvent(SDLK_PAGEUP);
  //registerEvent(SDLK_PAGEDOWN);
  registerEvent(EV_MOUSE_MOTION);

  this->getWeaponManager().setSlotCount(7);

  this->getWeaponManager().setSlotPosition(0, Vector(-2.6, .1, -3.0));
  this->getWeaponManager().setSlotCapability(0, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(1, Vector(-2.6, .1, 3.0));
  this->getWeaponManager().setSlotCapability(1, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(2, Vector(-1.5, .5, -.5));
  this->getWeaponManager().setSlotDirection(2, Quaternion(-M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(3, Vector(-1.5, .5, .5));
  this->getWeaponManager().setSlotDirection(3, Quaternion(M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(4, Vector(-1.5, -.5, .5));
  this->getWeaponManager().setSlotDirection(4, Quaternion(-M_PI_4*.5+M_PI, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(5, Vector(-1.5, -.5, -.5));
  this->getWeaponManager().setSlotDirection(5, Quaternion(+M_PI_4*.5-M_PI, Vector(1,0,0)));
//
   this->getWeaponManager().setSlotPosition(6, Vector(-1, 0.0, 0));
   this->getWeaponManager().setSlotCapability(6, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);
   //
//   this->getWeaponManager().setSlotPosition(8, Vector(-2.5, -0.3, -2.0));
//   this->getWeaponManager().setSlotDirection(8, Quaternion(-M_PI, Vector(1,0,0)));
//
//   this->getWeaponManager().setSlotPosition(9, Vector(-2.5, -0.3, 2.0));
//   this->getWeaponManager().setSlotDirection(9, Quaternion(+M_PI, Vector(1,0,0)));:

  this->getWeaponManager().getFixedTarget()->setParent(this);
  this->getWeaponManager().getFixedTarget()->setRelCoor(100000,0,0);

  dynamic_cast<Element2D*>(this->getWeaponManager().getFixedTarget())->setVisibility( false);

  this->burstEmitter = new DotEmitter(200, 0.0, .01);
  this->burstEmitter->setParent(this);
  this->burstEmitter->setRelCoor(-1, .5, 0);
  this->burstEmitter->setName("SpaceShip_Burst_emitter");

  this->burstSystem = new SpriteParticles(1000);
  this->burstSystem->addEmitter(this->burstEmitter);
  this->burstSystem->setName("SpaceShip_Burst_System");
  ((SpriteParticles*)this->burstSystem)->setMaterialTexture("maps/radial-trans-noise.png");
  this->burstSystem->setLifeSpan(1.0, .3);
  this->burstSystem->setRadius(0.0, 1.0);
  this->burstSystem->setRadius(0.05, 1.0);
  this->burstSystem->setRadius(.5, .8);
  this->burstSystem->setRadius(1.0, 0);
  this->burstSystem->setColor(0.0, .7,.7,1,.7);
  this->burstSystem->setColor(0.2, 0,0,0.8,.5);
  this->burstSystem->setColor(0.5, .5,.5,.8,.8);
  this->burstSystem->setColor(1.0, .8,.8,.8,.0);

  registerVar( new SynchronizeableVector( &velocity, &velocity, "velocity", PERMISSION_MASTER_SERVER ) );
  registerVar( new SynchronizeableQuaternion( &mouseDir, &mouseDir, "mousedir", PERMISSION_OWNER ) );

  registerVar( new SynchronizeableBool( &bUp, &bUp, "bUp", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bDown, &bDown, "bDown", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bLeft, &bLeft, "bLeft", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bRight, &bRight, "bRight", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bAscend, &bAscend, "bAscend", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bDescend, &bDescend, "bDescend", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bRollL, &bRollL, "bRollL", PERMISSION_OWNER ) );
  registerVar( new SynchronizeableBool( &bRollR, &bRollR, "bRollR", PERMISSION_OWNER ) );
}


/**
 * loads the Settings of a SpaceShip from an XML-element.
 * @param root the XML-element to load the Spaceship's properties from
 */
void SpaceShip::loadParams(const TiXmlElement* root)
{
  Playable::loadParams(root);
}

void SpaceShip::setPlayDirection(const Quaternion& quat, float speed)
{
  this->mouseDir = quat;
}


void SpaceShip::reset()
{
  bUp = bDown = bLeft = bRight = bAscend = bDescend = bRollL = bRollR = false;

  xMouse = yMouse = 0;

  this->setHealth(80);
  this->velocity = Vector(0.0, 0.0, 0.0);
}


void SpaceShip::enter()
{
  dynamic_cast<Element2D*>(this->getWeaponManager().getFixedTarget())->setVisibility( true);
  this->attachCamera();
}

void SpaceShip::leave()
{
  dynamic_cast<Element2D*>(this->getWeaponManager().getFixedTarget())->setVisibility( false);
  this->detachCamera();
}


/**
 *  effect that occurs after the SpaceShip is spawned
*/
void SpaceShip::postSpawn ()
{
  //setCollision(new CollisionCluster(1.0, Vector(0,0,0)));
}

/**
 *  the action occuring if the spaceship left the game
*/
void SpaceShip::leftWorld ()
{}

WorldEntity* ref = NULL;
/**
 *  this function is called, when two entities collide
 * @param entity: the world entity with whom it collides
 *
 * Implement behaviour like damage application or other miscellaneous collision stuff in this function
 */
void SpaceShip::collidesWith(WorldEntity* entity, const Vector& location)
{

}

/**
 *  draws the spaceship after transforming it.
*/
void SpaceShip::draw () const
{
  WorldEntity::draw();

  //this->debug(0);
}

/**
 *  the function called for each passing timeSnap
 * @param time The timespan passed since last update
*/
void SpaceShip::tick (float time)
{
  Playable::tick(time);

  if( ( xMouse != 0 || yMouse != 0 ) && this->getOwner() == SharedNetworkData::getInstance()->getHostID() )
   {
    if (xMouse > controlVelocityX) xMouse = controlVelocityX;
    else if (xMouse < -controlVelocityX) xMouse = -controlVelocityX;
    if (yMouse > controlVelocityY) yMouse = controlVelocityY;
    else if (yMouse < -controlVelocityY) yMouse = -controlVelocityY;

    pitchDir = (Quaternion(xMouse*mouseSensitivity*0.5, Vector(1,0,0)));

    mouseDir *= (Quaternion(-M_PI/4*xMouse*mouseSensitivity, Vector(0,1,0))*Quaternion(-M_PI/4*yMouse*mouseSensitivity*yInvert, Vector(0,0,1))*pitchDir);
    xMouse = yMouse = 0;
   }


//   if( this != State::getPlayer()->getControllable())
//     return;

  // spaceship controlled movement fire(bool bF){ this->bFire = bF;}
  //if (this->getOwner() == this->getHostID())
    this->calculateVelocity(time);


  Vector move = velocity*time;

  //orient the velocity in the direction of the spaceship.
  travelSpeed = velocity.len();
  velocity += ((this->getAbsDirX())*travelSpeed-velocity)*airViscosity;
  velocity = (velocity.getNormalized())*travelSpeed;
  this->burstEmitter->setEmissionRate(travelSpeed);
  this->burstEmitter->setEmissionVelocity(travelSpeed*.5, travelSpeed *.1);

  //orient the spaceship in direction of the mouse
   rotQuat = Quaternion::quatSlerp( this->getAbsDir(), mouseDir, 0.5);//fabsf(time)*shipInertia);
   if (this->getAbsDir().distance(rotQuat) > 0.00000000000001)
    this->setAbsDir( rotQuat);
   //this->setAbsDirSoft(mouseDir,5);

  // this is the air friction (necessary for a smooth control)
  if(travelSpeed >= 120) velocity -= velocity.getNormalized()*travelSpeed*travelSpeed*0.0001;
  else if (travelSpeed <= 80) velocity -= velocity.getNormalized()*travelSpeed*0.001;

  //other physics (gravity)
  //if(travelSpeed < 120)
  //move += Vector(0,-1,0)*60*time + Vector(0,1,0)*travelSpeed/2*time;

  //hoover effect
  //cycle += time;
  //this->shiftCoor(Vector(0,1,0)*cos(this->cycle*2.0)*0.02);

  //readjust
  //if (this->getAbsDirZ().y > 0.1) this->shiftDir(Quaternion(time*0.3, Vector(1,0,0)));
  //else if (this->getAbsDirZ().y < -0.1) this->shiftDir(Quaternion(-time*0.3, Vector(1,0,0)));

  //SDL_WarpMouse(GraphicsEngine::getInstance()->getResolutionX()/2, GraphicsEngine::getInstance()->getResolutionY()/2);

  this->shiftCoor(move);

//   PRINTF(0)("id of %s is: %i\n", this->getName(), this->getOMListNumber());

}

/**
 *  calculate the velocity
 * @param time the timeslice since the last frame
*/
void SpaceShip::calculateVelocity (float time)
{
  Vector accel(0.0, 0.0, 0.0);
  /*
  Vector rot(0.0, 0.0, 0.0); // wird ben�igt fr Helicopter
  */
  //float rotVal = 0.0;
  /* FIXME: calculating the direction and orthDirection every timeSlice is redundant! save it somewhere */
  /* calculate the direction in which the craft is heading  */

  //Plane plane(Vector(0,1,0), Vector(0,0,0));

  if( this->bUp )
   {
     //this->shiftCoor(this->getAbsDirX());
      //accel += (this->getAbsDirX())*2;
      accel += (this->getAbsDirX())*acceleration;

   }

  if( this->bDown )
   {
     //this->shiftCoor((this->getAbsDirX())*-1);
     //accel -= (this->getAbsDirX())*2;
    //if(velocity.len() > 50)
     accel -= (this->getAbsDirX())*0.5*acceleration;



   }

  if( this->bLeft/* > -this->getRelCoor().z*2*/)
  {
    this->shiftDir(Quaternion(time, Vector(0,1,0)));
//    accel -= rightDirection;
    //velocityDir.normalize();
    //rot +=Vector(1,0,0);
    //rotVal -= .4;
  }
  if( this->bRight /* > this->getRelCoor().z*2*/)
  {
    this->shiftDir(Quaternion(-time, Vector(0,1,0)));

    //    accel += rightDirection;
    //velocityDir.normalize();
    //rot += Vector(1,0,0);
    //rotVal += .4;
  }


  if( this->bRollL /* > -this->getRelCoor().z*2*/)
  {
    mouseDir *= Quaternion(-time*2, Vector(1,0,0));
//    accel -= rightDirection;
    //velocityDir.normalize();
    //rot +=Vector(1,0,0);
    //rotVal -= .4;
  }
  if( this->bRollR /* > this->getRelCoor().z*2*/)
  {
    mouseDir *= Quaternion(time*2, Vector(1,0,0));

    //    accel += rightDirection;
    //velocityDir.normalize();
    //rot += Vector(1,0,0);
    //rotVal += .4;
  }
  if (this->bAscend )
  {
    this->shiftDir(Quaternion(time, Vector(0,0,1)));

//    accel += upDirection;
    //velocityDir.normalize();
    //rot += Vector(0,0,1);
    //rotVal += .4;
  }
  if (this->bDescend )
  {
    this->shiftDir(Quaternion(-time, Vector(0,0,1)));

    //    accel -= upDirection;
    //velocityDir.normalize();
    //rot += Vector(0,0,1);
    //rotVal -= .4;
  }

  velocity += accel*time*10;
  //rot.normalize();
  //this->setRelDirSoft(Quaternion(rotVal, rot), 5);
}

/**
 * @todo switch statement ??
 */
void SpaceShip::process(const Event &event)
{
  Playable::process(event);

  if( event.type == KeyMapper::PEV_LEFT)
      this->bRollL = event.bPressed;
  else if( event.type == KeyMapper::PEV_RIGHT)
      this->bRollR = event.bPressed;
  else if( event.type == KeyMapper::PEV_FORWARD)
    this->bUp = event.bPressed; //this->shiftCoor(0,.1,0);
  else if( event.type == KeyMapper::PEV_BACKWARD)
    this->bDown = event.bPressed; //this->shiftCoor(0,-.1,0);
  else if( event.type == EV_MOUSE_MOTION)
  {
    this->xMouse += event.xRel;
    this->yMouse += event.yRel;
  }
}

void SpaceShip::destroy( WorldEntity* killer )
{
  PRINTF(0)("spaceship destroy\n");
}

void SpaceShip::respawn( )
{
  toList( OM_PLAYERS );
}




