/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Manuel Leuenberger
   co-programmer: ...
*/

#include "space_turret.h"
#include "model.h"
#include "world_entities/weapons/turret.h"

#include "state.h"
#include "playable.h"
#include "player.h"


#include "util/loading/factory.h"
#include "network_game_manager.h"
#include "util/loading/load_param.h"

#include "effects/explosion.h"

CREATE_FACTORY(SpaceTurret, CL_SPACE_TURRET);

/**
 * constructs and loads a SpaceTurret from a XML-element
 * @param root the XML-element to load from
 */
SpaceTurret::SpaceTurret(const TiXmlElement* root)
  : NPC(root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


/**
 * standard deconstructor
 */
SpaceTurret::~SpaceTurret ()
{

}


/**
 * initializes the SpaceTurret
 * @todo change this to what you wish
 */
void SpaceTurret::init()
{
  this->setClassID(CL_SPACE_TURRET, "SpaceTurret");
  this->loadModel("models/ground_turret_#.obj", 7.5);
  this->loadModel("models/comet.obj", 1.0f, 3);
  this->left = NULL;
  this->right = NULL;

  this->setHealthMax(100);
  this->setHealth(30);

  this->weaponHolder[0].addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
  this->weaponHolder[1].addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);

  this->weaponHolder[0].setRelCoor(0,25,0);
  this->weaponHolder[0].setParent(this);
  this->weaponHolder[1].setParent(this);

  this->wLeftHandle = registerVarId( new SynchronizeableString( &this->wLeft, &this->wLeft, "weapon-left", PERMISSION_MASTER_SERVER ) );
  this->wRightHandle = registerVarId( new SynchronizeableString( &this->wRight, &this->wRight, "weapon-right", PERMISSION_MASTER_SERVER ) );

}


/**
 * loads a SpaceTurret from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void SpaceTurret::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  NPC::loadParams(root);


  /**
   * @todo: make the class Loadable
   */
  const TiXmlElement* element;

  element = root->FirstChildElement("weapon-left");
  if (element != NULL) element = element->FirstChildElement();
  this->left = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->left)
  {
    this->wLeft = element->Value();

    this->left->setParent(this);
    this->left->toList(this->getOMListNumber());
    this->left->setRelCoor(0,15,-7.5);
    this->left->requestAction( WA_ACTIVATE);
    this->left->setParent(&this->weaponHolder[0]);
  }

  element = root->FirstChildElement("weapon-right");
  if (element != NULL)  if (element != NULL) element = element->FirstChildElement();
  this->right = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->right)
  {
    this->wRight = element->Value();

    this->right->setParent(this);
    this->right->toList(this->getOMListNumber());
    this->right->setRelCoor(0,15,7.5);
    this->left->requestAction( WA_ACTIVATE);
    this->right->setParent(&this->weaponHolder[0]);
  }
}


/**
 * sets the left weapon called from net sync
 * @param wLeft the left weapon string
 */
void SpaceTurret::setWeaponLeft(const std::string& wLeft)
{

}

/**
 * sets the left weapon called from net sync
 * @param wRught the right weapon string
 */
void SpaceTurret::setWeaponRight(const std::string& wRight)
{}

/**
 * advances the SpaceTurret about time seconds
 * @param time the Time to step
 */
void SpaceTurret::tick(float dt)
{
  if(this->getHealth() > 0.0f && State::getPlayer() &&
     State::getPlayer()->getPlayable() &&
     State::getPlayer()->getPlayable()->distance(this) < 300) // HACK
  {
  if (likely(this->left != NULL))
  {
//    this->left->tickW(dt);
    this->left->requestAction(WA_SHOOT);
  }
  if (likely(this->right != NULL))
  {
//    this->right->tickW(dt);
    this->right->requestAction(WA_SHOOT);
  }
  }
}

/**
 * draws this worldEntity
 */
void SpaceTurret::draw () const
{
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);

  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->getModel()->draw();
  if (this->getModel() != NULL)
    this->getModel(3)->draw();
  glPopMatrix();
/*
  if (this->left != NULL)
    this->left->draw();
  if (this->right != NULL)
    this->right->draw();*/
}



/**
 *
 *
 */
void SpaceTurret::postSpawn ()
{

}

/**
 *
 *
 */
void SpaceTurret::leftWorld ()
{

}

void SpaceTurret::destroy(WorldEntity* killer)
{
  this->setAbsDirSoft(Quaternion(-90, Vector(0,0,1)), 90);
  Explosion::explode(this, Vector(10,10,10));

  this->toList(OM_DEAD);

  if (this->left)
    this->left->toList(OM_DEAD);
  if (this->right)
    this->right->toList(OM_DEAD);

}



/**
 * handler for changes on registred vars
 * @param id id's which changed
 */
void SpaceTurret::varChangeHandler( std::list< int > & id )
{
  if ( std::find( id.begin(), id.end(), this->wLeftHandle ) != id.end())
  {
    this->setWeaponLeft(this->wLeft);
  }

  if ( std::find( id.begin(), id.end(), this->wRightHandle ) != id.end() )
  {
    this->setWeaponRight(this->wRight);
  }


  WorldEntity::varChangeHandler( id );
}

