/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Manuel Leuenberger
   co-programmer: ...
*/

#include "network_turret.h"
#include "model.h"
#include "world_entities/weapons/turret.h"

#include "state.h"
#include "playable.h"
#include "player.h"


#include "util/loading/factory.h"
#include "network_game_manager.h"
#include "util/loading/load_param.h"

#include "effects/explosion.h"

#include "weapons/aiming_turret.h"

CREATE_FACTORY(NetworkTurret, CL_NETWORK_TURRET);




/**
 * constructs and loads a NetworkTurret from a XML-element
 * @param root the XML-element to load from
 */
NetworkTurret::NetworkTurret(const TiXmlElement* root)
    : NPC(root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


/**
 * standard deconstructor
 */
NetworkTurret::~NetworkTurret ()
{}


/**
 * initializes the NetworkTurret
 * @todo change this to what you wish
 */
void NetworkTurret::init()
{
  this->setClassID(CL_NETWORK_TURRET, "NetworkTurret");
  this->loadModel("models/ground_turret_#.obj", 5);

  this->weapon = new AimingTurret();
  this->weapon->loadModel("models/guns/turret2.obj", 10);
  this->weapon->setParent(this);
  this->weapon->toList(this->getOMListNumber());
  this->weapon->setRelCoor(0,10,-5);
  this->weapon->requestAction( WA_ACTIVATE);
  this->weapon->setParent(&this->weaponHolder);

  this->setHealthMax(300);
  this->setHealth(300);

  this->weaponHolder.addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);

  this->weaponHolder.setRelCoor(0,25,0);
  this->weaponHolder.setParent(this);


  this->targetGroup = OM_GROUP_01;
  this->targetGroup_write = OM_GROUP_01;
  this->targetGroup_handle = this->registerVarId( new SynchronizeableInt ( &targetGroup, &targetGroup_write, "targetgroup", PERMISSION_MASTER_SERVER ) );

  this->setSynchronized( true );
}


/**
 * @brief loads a NetworkTurret from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void NetworkTurret::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  NPC::loadParams(root);

  LoadParam(root, "target-group", this, NetworkTurret, setTargetGroupS);
}

/**
 * advances the NetworkTurret about time seconds
 * @param time the Time to step
 */
void NetworkTurret::tick(float dt)
{
  ObjectManager::EntityList::iterator entity;
  Vector diffVec;
  for (entity = State::getObjectManager()->getObjectList((OM_LIST)this->targetGroup).begin();
       entity != State::getObjectManager()->getObjectList((OM_LIST)this->targetGroup).end();
       entity ++)
  {
    diffVec = ( (*entity)->getAbsCoor() - this->getAbsCoor() );

    if ( diffVec.len() < 400.0 )//&&  acos( (this->source->getAbsDirX()).dot(diffVec)/(diffVec.len() * (this->source->getAbsDirX()).len() ) )  < angle)
    {
      //if (this->getParent() != (*entity))
      {
        this->weapon->requestAction(WA_SHOOT);
        return;
      }
    }
  }
}

/**
 * draws this worldEntity
 */
void NetworkTurret::draw () const
{
  WorldEntity::draw();

  if (this->weapon != NULL)
    this->weapon->draw();
}

void NetworkTurret::setTargetGroup(int targetGroup)
{
  this->targetGroup = targetGroup;
  this->weapon->setTargetGroup((OM_LIST)targetGroup);
}


void NetworkTurret::setTargetGroupS(const std::string& groupName)
{
  OM_LIST id = ObjectManager::StringToOMList(groupName);
  if (id != OM_NULL)
    this->setTargetGroup(id);
  else
    PRINTF(2)("List %s not found for targetting\n", groupName.c_str());
}

void NetworkTurret::varChangeHandler( std::list< int > & id )
{
  WorldEntity::varChangeHandler( id );

  if ( std::find( id.begin(), id.end(), targetGroup_handle) != id.end() )
  {
    setTargetGroup( targetGroup_write );
  }
}

/**
 *
 *
 */
void NetworkTurret::postSpawn ()
{}

/**
 *
 *
 */
void NetworkTurret::leftWorld ()
{}

void NetworkTurret::destroy(WorldEntity* killer)
{
  this->setAbsDirSoft(Quaternion(-90, Vector(0,0,1)), 90);
  Explosion::explode(this, Vector(10,10,10));

  this->toList(OM_DEAD);
}
