/*!
 * @file synchronizeable_ip.h
 * @brief Definition of SynchronizeableIP
*/


#ifndef _SYNCHRONIZEABLE_IP_H
#define _SYNCHRONIZEABLE_IP_H

#include "synchronizeable_var.h"

class IP;

class SynchronizeableIP : public SynchronizeableVar {

  public:
    SynchronizeableIP( IP *ptrIn, IP * ptrOut, std::string name, int permission, int priority = 0 );
    virtual ~SynchronizeableIP();

    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );

    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; }

    virtual void debug();


  private:
    IP * vPtrIn;       //!< pointer to data (read)
    IP * vPtrOut;      //!< pointer to data (write)

};

#endif /* _PROTO_CLASS_H */
