/*!
 * @file synchronizeable_int.h
 * @brief Definition of SynchronizeableInt
*/


#ifndef _SYNCHRONIZEABLE_INT_H
#define _SYNCHRONIZEABLE_INT_H

#include "synchronizeable_var.h"

class SynchronizeableInt : public SynchronizeableVar {

  public:
    SynchronizeableInt( int * ptrIn, int * ptrOut, std::string name, int permission, int priority = 0 );
    virtual ~SynchronizeableInt();

    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );

    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; };

    virtual void debug();

  protected:
    int * vPtrIn;       //!< pointer to data (read)
    int * vPtrOut;      //!< pointer to data (write)


};

#endif /* _PROTO_CLASS_H */
