/*!
 * @file synchronizeable_float.h
 * @brief Definition of SynchronizeableFloat
 */


#ifndef _SYNCHRONIZEABLE_FLOAT_H
#define _SYNCHRONIZEABLE_FLOAT_H

#include "synchronizeable_var.h"

class SynchronizeableFloat : public SynchronizeableVar {

  public:
    SynchronizeableFloat( float * ptrIn, float * ptrOut, std::string name, int permission, int priority = 0 );
    virtual ~SynchronizeableFloat();

    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );

    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; };

    virtual void debug();

  private:
    float * vPtrIn;       //!< pointer to data (read)
    float * vPtrOut;      //!< pointer to data (write)

};

#endif /* _PROTO_CLASS_H */
