/*!
 * @file player_stats.h
 * @brief Definition of ProxyControl
 *
 * manages the clients on the proxies (connect/disconnect)
 */

#ifndef _PROXY_SETTINGS_H
#define _PROXY_SETTINGS_H

#include "synchronizeable.h"
#include "message_manager.h"

#include <string>
#include <list>


typedef enum proxyCommand {
  PXY_RECONNECT              = 0,              //!< forces a reconnection of the node

  PXY_WEAKUP,                                  //!< signal to weakup a sleeping proxy server (not impl. yet)
  PXY_SLEEP,                                   //!< signal to sleep and disconnect clients

  PXY_NUMBER
};



//! A class for storing player information
class ProxyControl : public Synchronizeable
{

  public:
    inline static ProxyControl* getInstance() { if (!ProxyControl::singletonRef) ProxyControl::singletonRef = new ProxyControl();
      return ProxyControl::singletonRef; }
    virtual ~ProxyControl();

    virtual void varChangeHandler( std::list<int> & id );

    /* connection signal handling */
    void signalNewClient(int userId);
    static bool messageHandlerNewClient( MessageType messageType, byte * data, int dataLength, void * someData, int senderId, int destinationId  );

    void signalLeaveClient(int userId);
    static bool messageHandlerLeaveClient( MessageType messageType, byte * data, int dataLength, void * someData, int senderId, int destinationId  );

    /* proxy server network control */
    void forceReconnectionShellThumb();
    void forceReconnectionShell(int userId, int serverId);
    void forceReconnection(int userId, int serverId);
    void forceReconnection(int userId, IP newAddress);
    void forceReconnection(int userId, const std::string& newAddress);
    static bool messageHandlerCommand( MessageType messageType, byte * data, int dataLength, void * someData, int senderId, int destinationId  );

  private:
    ProxyControl();


  private:
    static ProxyControl*      singletonRef;            //!< Pointer to the only instance of this Class


};

#endif /* _PROXY_SETTINGS_H */
