/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_text.h"

#include "text.h"

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiText::GLGuiText ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiText::~GLGuiText()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiText::init()
  {
    this->setClassID(CL_GLGUI_TEXT, "GLGuiText");

    this->_text.setParent2D(this);
    this->_text.setRelCoor2D(4,4);
    this->_text.setFont("fonts/final_frontier.ttf", 20);
    this->_text.setLineWidth(400);
    this->_text.setDotsPosition(LimitedWidthText::Begin);
    this->_text.setColor(foregroundColor());
    this->_text.setVisibility(false);
    this->_changedTextColor = Color::white;
    this->resize();
  }

  /**
  * @brief sets the Text of the Text
  * @param text The new Text.
   */
  void GLGuiText::setText(const std::string& text)
  {
    this->_text.setText(text);
    this->changedText();
  }

  /**
   * @brief appends text to the Text
   * @param appendText the Text to append
   */
  void GLGuiText::append(const std::string& appendText)
  {
    this->_text.append(appendText);
    this->changedText();
  }


  /**
   * @brief appends a Character to the Text
   * @param character the Character to append.
   */
  void GLGuiText::appendCharacter(char character)
  {
    this->_text.appendCharacter(character);
    this->changedText();
  }


  /**
   * @brief Removes Characters from the Text
   * @param chars The count of characters to remove
   */
  void GLGuiText::removeCharacters(unsigned int chars)
  {
    this->_text.removeCharacters(chars);
    this->changedText();
  }

  void GLGuiText::clear()
  {
    this->_text.clear();
    this->resize();
  }


  /**
  * @brief If the Text has been changed this function is called.
  *
  * This Function also emits the Signal textChanged.
   */
  void GLGuiText::changedText()
  {
    this->resize();
    this->setFrontColor(_changedTextColor, true);
    this->textChanged.emit(this->_text.text());
  }

  void GLGuiText::setTextSize(float size)
  {
    this->_text.setSize(size);
    this->changedText();
  }

  void GLGuiText::setFont(const Font& font)
  {
    GLGuiWidget::setFont(font);
    this->_text.setFont(font);
  }

  void GLGuiText::setChangedTextColor(const Color& color)
  {
    this->_changedTextColor = color;
  }

  /**
   * @brief Resizes the Widget to the new Size-constraints.
   */
  void GLGuiText::resize()
  {
    this->_text.setRelCoor2D(borderLeft(), borderTop());
    this->setSize2D( this->_text.getSize2D() + Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));
    //this->_text.setLineWidth(this->size2D);
    GLGuiWidget::resize();
    /*    this->frontRect().setTopLeft(borderLeft(), borderTop());
    this->frontRect().setSize(this->getSize2D() - Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));*/
  }

  void GLGuiText::updateFrontColor()
  {
    this->_text.setColor(foregroundColor());
  }

  void GLGuiText::hiding()
  {
    this->_text.setVisibility(false);
  }

  void GLGuiText::showing()
  {
    this->_text.setVisibility(true);
  }



  /**
   * draws the GLGuiText
   */
  void GLGuiText::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    //     this->frontMaterial().select();
    //     GLGuiWidget::drawRect(this->frontRect());

    this->endDraw();
  }
}
