/*!
 * @file glgui_box.h
 * The gl_box widget of th openglGUI
 *
 */

#ifndef _GLGUI_BOX_H
#define _GLGUI_BOX_H

#include "glgui_container.h"
#include "glgui_defs.h"

namespace OrxGui
{
  //! This is BOX part of the openglGUI class
  /**
   *
   */
  class GLGuiBox : public GLGuiContainer
  {

  public:
    GLGuiBox(OrxGui::Orientation orientation = OrxGui::Vertical);
    virtual ~GLGuiBox();

    /** @returns the Orientation of the Box */
    OrxGui::Orientation orientation() const { return this->_orientation; };
    /** @param orientation the Orientation of the Box */
    void setOrientation(OrxGui::Orientation orientation) { this->_orientation = orientation; };

    virtual void pack(GLGuiWidget* widget);
    void pack(GLGuiWidget* widget, unsigned int position);
    void pack(GLGuiWidget* widget, GLGuiWidget* widgetPointer);
    void packFront(GLGuiWidget* widget);
    void packBack(GLGuiWidget* widget);
    virtual void unpack(GLGuiWidget* widget);

    virtual void clear();

    virtual void showAll();
    virtual void hideAll();

    virtual void draw() const;

  protected:
    virtual void resize();

  private:
    void init();
    void packing(GLGuiWidget* widget); // the action executing when packing a widget.
    void pack(GLGuiWidget* widget, std::list<GLGuiWidget*>::iterator pos);

  private:


    Orientation                _orientation;
    std::list<GLGuiWidget*>    _children;
  };
}
#endif /* _GLGUI__H */
