/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_fixedposition_box.h"
#include "glgui_handler.h"

#include <cassert>

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiFixedpositionBox::GLGuiFixedpositionBox (OrxGui::Position position, OrxGui::Orientation orientation)
      : GLGuiBox(orientation)
  {}


  void GLGuiFixedpositionBox::setPosition(OrxGui::Position position)
  {
    this->_position = position;
    this->resize();
  }


  void GLGuiFixedpositionBox::resize()
  {
    GLGuiBox::resize();

    switch (this->_position)
    {
      case OrxGui::Center:
        this->setAbsCoor2D(GLGuiHandler::getInstance()->resolution() - this->getSize2D() / 2.0);
        break;
      default:
        printf("not done mode yet!!\n");

    }
    // resize everything.
    //for (widget = this->children.begin(); widget != this->children.end(); ++widget)
    //{}
  }

}
