/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli (patrick@orxonox.ethz.ch)
*/

#include "proxy_control.h"

#include "class_list.h"


#include "player.h"
#include "state.h"
#include "shared_network_data.h"
#include "network_game_manager.h"

#include "converter.h"

#include "preferences.h"

#include "debug.h"




ProxyControl* ProxyControl::singletonRef = NULL;


/**
 * constructor
 */
ProxyControl::ProxyControl()
{
  this->setClassID( CL_PROXY_CONTROL, "ProxyControl" );

  MessageManager::getInstance()->registerMessageHandler( MSGID_PROXY_NEWCLIENT, messageHandlerNewClient, NULL );

  PRINTF(0)("ProxyControl created\n");
}


/**
 * standard deconstructor
 */
ProxyControl::~ProxyControl()
{
  ProxyControl::singletonRef = NULL;
}


 /**
 * override this function to be notified on change
 * of your registred variables.
 * @param id id's which have changed
  */
void ProxyControl::varChangeHandler( std::list< int > & id )
{
//   if ( std::find( id.begin(), id.end(), playableUniqueId_handle ) != id.end() )
//   {
//     this->setPlayableUniqueId( this->playableUniqueId );
//
//     PRINTF(0)("uniqueID changed %d %d %d\n", userId, SharedNetworkData::getInstance()->getHostID(), getUniqueID());
//   }
}


/**
 *  signals new client connected to this local proxy
 * @param userId userId of the new client
 */
void ProxyControl::signalNewClient(int userId)
{
  PRINTF(0)("Signaling new Client: %i\n");
  // make sure we are a proxy server
  assert(SharedNetworkData::getInstance()->isProxyServerActive());

  byte * data = new byte[INTSIZE];

  assert( Converter::intToByteArray( userId, data + INTSIZE, INTSIZE ) == INTSIZE );

  MessageManager::getInstance()->sendMessage( MSGID_PROXY_NEWCLIENT, data, INTSIZE, RT_SERVER, NET_UNASSIGNED, MP_HIGHBANDWIDTH );
}


/**
 * this is the handler for proxy signals: new clients
 *
 * @param messageType the type of the message
 * @param data message data
 * @param dataLength length of the message data
 * @param someData some other atteched data
 * @param senderId id of the sender client
 * @param destinationId id of the destination client
 * @return true if succeeded
 */
bool ProxyControl::messageHandlerNewClient( MessageType messageType, byte * data, int dataLength, void * someData, int senderId, int destinationId  )
{
  int userId = 0;
  // body data length correct?
  if ( dataLength != INTSIZE )
  {
    PRINTF(2)("new client message has wrong size: %d\n", dataLength );
    return true;
  }
  // read the userId fromt he message body
  assert( Converter::byteArrayToInt( data, &userId) == INTSIZE );

  PRINTF(0)("Got Signal: new player arrived with userId: %i\n", userId);
  // part for the master server
  if( SharedNetworkData::getInstance()->isMasterServer())
  {
    // we now create the new player ship and stuff...
    NetworkGameManager::getInstance()->signalNewPlayer(userId);
  }
  else if(SharedNetworkData::getInstance()->isProxyServerActive())
  {

  }

  return true;
}
