/*!
 * @file player_stats.h
 * @brief Definition of ProxyControl
 */

#ifndef _PROXY_SETTINGS_H
#define _PROXY_SETTINGS_H

#include "synchronizeable.h"
#include "message_manager.h"

#include <string>
#include <list>





//! A class for storing player information
class ProxyControl : public Synchronizeable
{

  public:
    inline static ProxyControl* getInstance() { if (!ProxyControl::singletonRef) ProxyControl::singletonRef = new ProxyControl();
      return ProxyControl::singletonRef; }
    virtual ~ProxyControl();

    virtual void varChangeHandler( std::list<int> & id );

    void signalNewClient(int userId);
    static bool messageHandlerNewClient( MessageType messageType, byte * data, int dataLength, void * someData, int senderId, int destinationId  );


  private:
    ProxyControl();


  private:
    static ProxyControl*      singletonRef;            //!< Pointer to the only instance of this Class


};

#endif /* _PROXY_SETTINGS_H */
