/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Manuel Leuenberger
   co-programmer: ...
*/

#include "ground_turret.h"
#include "model.h"
#include "world_entities/weapons/turret.h"

#include "state.h"
#include "playable.h"
#include "player.h"


#include "util/loading/factory.h"
#include "network_game_manager.h"
#include "util/loading/load_param.h"

#include "effects/explosion.h"

CREATE_FACTORY(GroundTurret, CL_GROUND_TURRET);




/**
 * constructs and loads a GroundTurret from a XML-element
 * @param root the XML-element to load from
 */
GroundTurret::GroundTurret(const TiXmlElement* root)
    : NPC(root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


/**
 * standard deconstructor
 */
GroundTurret::~GroundTurret ()
{
}


/**
 * initializes the GroundTurret
 * @todo change this to what you wish
 */
void GroundTurret::init()
{
  this->setClassID(CL_GROUND_TURRET, "GroundTurret");
  this->loadModel("models/ground_turret_#.obj", 5);
  this->left = NULL;
  this->right = NULL;

  this->setHealthMax(300);
  this->setHealth(300);

  this->weaponHolder[0].addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
  this->weaponHolder[1].addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);

  this->weaponHolder[0].setRelCoor(0,25,0);
  this->weaponHolder[0].setParent(this);
  this->weaponHolder[1].setParent(this);
}


/**
 * @brief loads a GroundTurret from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void GroundTurret::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  NPC::loadParams(root);

  /**
   * @todo: make the class Loadable
   */
  const TiXmlElement* element;

  element = root->FirstChildElement("weapon-left");
  if (element != NULL) element = element->FirstChildElement();
  this->left = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->left)
  {
    this->left->setParent(this);
    this->left->toList(this->getOMListNumber());
    this->left->setRelCoor(0,10,-5);
    this->left->requestAction( WA_ACTIVATE);
    this->left->setParent(&this->weaponHolder[0]);
  }

  element = root->FirstChildElement("weapon-right");
  if (element != NULL)  if (element != NULL) element = element->FirstChildElement();
  this->right = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->right)
  {
    this->right->setParent(this);
    this->right->toList(this->getOMListNumber());
    this->right->setRelCoor(0,10,5);
    this->left->requestAction( WA_ACTIVATE);
    this->right->setParent(&this->weaponHolder[0]);
  }
}

/**
 * advances the GroundTurret about time seconds
 * @param time the Time to step
 */
void GroundTurret::tick(float dt)
{
  if(this->getHealth() > 0.0f
    ) // HACK <--- YOU ARE THE MOTHERFUCKER
  {
    if (likely(this->left != NULL))
    {
      //    this->left->tickW(dt);
      this->left->requestAction(WA_SHOOT);
    }
    if (likely(this->right != NULL))
    {
      //    this->right->tickW(dt);
      this->right->requestAction(WA_SHOOT);
    }
  }
}

/**
 * draws this worldEntity
 */
void GroundTurret::draw () const
{
  WorldEntity::draw();

  if (this->left != NULL)
    this->left->draw();
  if (this->right != NULL)
    this->right->draw();
}



/**
 *
 *
 */
void GroundTurret::postSpawn ()
{
}

/**
 *
 *
 */
void GroundTurret::leftWorld ()
{
}

void GroundTurret::destroy(WorldEntity* killer)
{
  this->setAbsDirSoft(Quaternion(-90, Vector(0,0,1)), 90);
  Explosion::explode(this, Vector(10,10,10));

  this->toList(OM_DEAD);
}
