/*!
 * @file aiming_turret.h
*/


#ifndef _TARGETING_TURRET_H
#define _TARGETING_TURRET_H

#include "weapon.h"
#include "aim.h"

class TargetingTurret : public Weapon
{
public:
  TargetingTurret(const TiXmlElement* root = NULL);
  virtual ~TargetingTurret ();

  virtual void loadParams(const TiXmlElement* root);

  virtual void activate();
  virtual void deactivate();

  virtual void tick(float dt);
  virtual void fire();

  virtual void draw() const;

  const PNode* getLockedTarget() const { return lockedTarget; };

private:
  void init();

private:
  Aim            target;
  PNode*         lockedTarget;
  float          lockedTime;
  float          neededLockTime;
};

#endif /* _TARGETING_TURRET_H */
