/*!
 * @file entity_manager.h
 *  Manages creation and destruction of entities
 */

#ifndef _NETWORK_GAME_MANGER
#define _NETWORK_GAME_MANAGER

/* include this file, it contains some default definitions */
#include "netdefs.h"

/* include base_object.h since all classes are derived from this one */
#include "synchronizeable.h"
#include "playable.h"
#include "message_manager.h"


class TiXmlElement;
class PNode;

typedef enum NetworkGameManagerProtocol {
  NET_CREATE_ENTITY = 0,
  NET_REMOVE_ENTITY,
  NET_CREATE_ENTITY_LIST,
  NET_REMOVE_ENTITY_LIST,
  NET_REQUEST_CREATE,
  NET_REQUEST_REMOVE,
  NET_YOU_ARE_ENTITY,
  NET_REQUEST_ENTITY_LIST,

  NET_NUMBER
};

struct clientBuffer
{
  int length;
  int maxLength;
  byte * buffer;
};

/*!
 * a class that can create and remove entities over the network
 */
class NetworkGameManager: public Synchronizeable
{

  public:
    virtual ~NetworkGameManager();

    static NetworkGameManager* NetworkGameManager::getInstance()
    { if (!NetworkGameManager::singletonRef) NetworkGameManager::singletonRef = new NetworkGameManager(); return NetworkGameManager::singletonRef; }


    bool signalNewPlayer( int userId );
    bool signalLeftPlayer( int userID );

    void prefereTeam( int teamId );


    inline void setGameState( int gameState ){ this->gameState = gameState; }
    inline int getGameState(){ return this->gameState; }

    void tick( float ds );

    void removeSynchronizeable( int uniqueId );
    void sendChatMessage( const std::string & message, int messageType );


  private:
    NetworkGameManager();

    static bool delSynchronizeableHandler( MessageType messageType, byte * data, int dataLength, void * someData, int userId );
    static bool preferedTeamHandler( MessageType messageType, byte * data, int dataLength, void * someData, int userId );
    static bool chatMessageHandler( MessageType messageType, byte * data, int dataLength, void * someData, int userId );

    void setPreferedTeam( int userId, int teamId );


  private:
    static NetworkGameManager*    singletonRef;

    int                           gameState;

    std::list<Playable*>          playablesToDelete;
};

#endif /*_ENTITY_MANGER*/
