/*!
 * @file player_stats.h
 * @brief Definition of PlayerStats
 */

#ifndef _PLAYER_STATS_H
#define _PLAYER_STATS_H

#include "synchronizeable.h"
#include "playable.h"
#include "message_manager.h"

#include <string>
#include <list>

enum
{
  TEAM_NOTEAM = -3,
  TEAM_RANDOM = -2,
  TEAM_SPECTATOR = -1
};

struct PlayerScore
{
  std::string name;
  int score;
};
typedef std::list<PlayerScore> TeamScoreList;
typedef std::map<int,TeamScoreList> ScoreList;

//! A class for storing player information
class PlayerStats : public Synchronizeable
{

  public:
    PlayerStats( const TiXmlElement* root = NULL );
    PlayerStats( int userId );
    virtual ~PlayerStats();

    virtual void varChangeHandler( std::list<int> & id );

    static PlayerStats * getStats( int userId );

    inline int getUserId(){ return userId; }

    inline int getTeamId(){ return teamId; }
    inline void setTeamId( int teamId ){ this->teamId = teamId; }

    inline int getPreferedTeamId(){ return preferedTeamId; }
    inline void setPreferedTeamId( int preferedTeamId ) { this->preferedTeamId = preferedTeamId; }

    inline int getScore(){ return score; }
    inline void setScore( int score ){ this->score = score; }

    inline int getPlayableClassId(){ return playableClassId; }
    void setPlayableClassId( int classId ){ this->playableClassId = classId; };

    inline int getPlayableUniqueId(){ return playableUniqueId; }
    void setPlayableUniqueId( int uniqueId );

    inline std::string getModelFileName(){ return modelFileName; }
    inline void setModelFileName( std::string filename ){ modelFileName = filename; }

    Playable * getPlayable();

    inline std::string getNickName(){ return this->nickName; }
    void setNickName( std::string nick );
    static bool changeNickHandler( MessageId messageId, byte * data, int dataLength, void * someData, int userId );
    void shellNick( const std::string&  newNick );

    static void deleteAllPlayerStats();

    static ScoreList getScoreList();


  private:
    void init();


  private:
    // handles for SynchronizeableVars
    int              userId_handle;
    int              teamId_handle;
    int              preferedTeamId_handle;
    int              score_handle;
    int              playableClassId_handle;
    int              playableUniqueId_handle;
    int              modelFileName_handle;
    int              nickName_handler;

    int              userId;                    //!< userId
    int              teamId;                    //!< teamId
    int              preferedTeamId;            //!< preferedTeamId

    std::string      nickName;                  //!< players nickname
    std::string      oldNickName;               //!< nickname player had before

    int              score;                     //!< users score points
    int              playableClassId;           //!< players playable class id
    int              playableUniqueId;          //!< playable's uniqueId
    std::string      modelFileName;             //!< model filename

    Playable *       playable;                  //!< pointer to players playable
};

#endif /* _PLAYER_STATS_H */
