/*!
 * @file peer_info.h
 *  implementation a peer info
 */

#ifndef _PEER_INFO_H
#define _PEER_INFO_H

#include "server_socket.h"
#include "handshake.h"
#include "monitor/connection_monitor.h"

#include <string>

//!< this structure contains informations about the network node
class PeerInfo
{
  public:
    PeerInfo();

    void clear();


    inline bool isMasterServer() const { return this->nodeType == NET_MASTER_SERVER; }
    inline bool isProxyServer() const { return this->nodeType == NET_PROXY_SERVER_ACTIVE; }
    inline bool isProxyServerPassive() const { return this->nodeType == NET_PROXY_SERVER_PASSIVE; }
    inline bool isClient() const { return this->nodeType == NET_CLIENT; }

    const std::string& getNodeTypeString() const;
    static const std::string& nodeTypeToString(unsigned int type);



  public:
    int                 userId;                  //!< id of this network node
    int                 nodeType;                //!< type of this network node
    IP                  ip;                      //!> the ip address of this network node

    NetworkSocket *     socket;                  //!< socket connecting to this node
    Handshake *         handshake;               //!< the handshake object, active on connection setup
    ConnectionMonitor * connectionMonitor;       //!< ConnectionMonitor monitoring the current network traffic

    int                 lastAckedState;          //!< last acked state synchronized state
    int                 lastRecvedState;         //!< last received state

    static const std::string nodeNames[];

};



#endif /* _PEER_INFO_H */
