/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/


#define DEBUG_MODULE_NETWORK

#include "network_settings.h"

#include "netdefs.h"
#include "shared_network_data.h"

#include "loading/resource_manager.h"
#include "loading/load_param.h"

#include "debug.h"



NetworkSettings* NetworkSettings::singletonRef = NULL;

/**
 * Standard constructor
 */
NetworkSettings::NetworkSettings()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_SETTINGS, "NetworkSettings");

  // suggest a good standard max players value
  this->maxPlayer = 10;
}


/**
 * Standard destructor
 */
NetworkSettings::~NetworkSettings()
{
  NetworkSettings::singletonRef = NULL;

  // remove all unused proxy data again
  for(unsigned int i = 0; i < this->proxies.size(); i++)
  {
    IP ip = this->proxies.back();
    this->proxies.pop_back();
  }
}


/**
 *  this loads the proxy settings from a configuration file
 */
void NetworkSettings::loadData()
{
  std::string fileName = ResourceManager::getInstance()->getDataDir();
  fileName += "configs/network_settings.conf";

  TiXmlDocument doc(fileName);
  if( !doc.LoadFile(fileName))
  {
    PRINTF(1)("Loading file %s failed for Network Settings.\n", fileName.c_str());
    return;
  }
  const TiXmlElement* root = doc.RootElement();

  if( strcmp( root->Value(), "NetworkSettings"))
  {
    // report an error
    PRINTF(1)("Specified XML File is not an orxonox Network Settings file (NetworkSettings element missing)\n");
    return;
  }

  this->loadNetworkSettings( root);

  // set the new unique id offset
  // setUniqueID( maxCon+2 ) because we need one id for every handshake
  // and one for handshake to reject client maxCon+1
  SharedNetworkData::getInstance()->setNewUniqueID( this->maxPlayer + 2);
}



/**
 * load the proxy settings
 * @param root: the root element of the xml elemnts
 */
void NetworkSettings::loadNetworkSettings(const TiXmlElement* root)
{
  LoadParam(root, "master-addr", this, NetworkSettings, setMasterAddr);

  LoadParam(root, "max-player", this, NetworkSettings, setMaxPlayer);
  LoadParam(root, "max-player-saturation", this, NetworkSettings, setMaxPlayerSaturation);


  LOAD_PARAM_START_CYCLE(root, element);
  {
    element->ToText();
    LoadParam_CYCLE(element, "proxy-addr", this, NetworkSettings, setProxyAddr);
  }
  LOAD_PARAM_END_CYCLE(element);

}


/**
 * sets the master server address
 * @param masterAddr: the address of the master server
 */
void NetworkSettings::setMasterAddr(const std::string& masterAddr)
{
  IPaddress *ip = new IPaddress;

  SDLNet_ResolveHost( ip, masterAddr.c_str(), 9999 );

  this->masterServer = *ip;
}


/**
 * sets the proxy address to
 *  @param proxyAddr: the proxy address
 */
void NetworkSettings::setProxyAddr(const std::string& proxyAddr)
{

  if( !SharedNetworkData::getInstance()->isMasterServer())
    return;

  IP ip(proxyAddr, 9999);
  printf("========== ");
  ip.debug();

  this->proxies.push_back(ip);//IP(proxyAddr, 9999));
}







