/*
  orxonox - the future of 3D-vertical-scrollers

  Copyright (C) 2004 orx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

### File Specific:
  main-programmer: hdavid, amaechler
*/

#include "volfog_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "p_node.h"
#include "state.h"

#include "glincl.h"
//#include "shell_command.h"

#define GLX_GLXEXT_PROTOTYPES
//#include <GL/glx.h>
// #include <GL/glut.h>

//#include <GL/glext.h> //OpenGL Extensions
//#include <GL/glxext.h> // GLX Extensions
#ifndef __APPLE__
#ifndef GL_EXT_fog_coord
#define GL_EXT_fog_coord 1
typedef void (APIENTRY * PFNGLFOGCOORDFEXTPROC) (GLfloat coord);
typedef void (APIENTRY * PFNGLFOGCOORDFVEXTPROC) (const GLfloat *coord);
typedef void (APIENTRY * PFNGLFOGCOORDDEXTPROC) (GLdouble coord);
typedef void (APIENTRY * PFNGLFOGCOORDDVEXTPROC) (const GLdouble *coord);
typedef void (APIENTRY * PFNGLFOGCOORDPOINTEREXTPROC) (GLenum type, GLsizei stride, const GLvoid *pointer);
#endif

PFNGLFOGCOORDFEXTPROC glFogCoordfEXT = 0;
PFNGLFOGCOORDFVEXTPROC glFogCoordfvEXT = 0;
PFNGLFOGCOORDDEXTPROC glFogCoorddEXT = 0;
PFNGLFOGCOORDDVEXTPROC glFogCoorddvEXT = 0;
PFNGLFOGCOORDPOINTEREXTPROC glFogCoordPointerEXT = 0;
#endif



CREATE_FACTORY(VolFogEffect, CL_VOLFOG_EFFECT);

VolFogEffect::VolFogEffect(const TiXmlElement* root) {
    this->setClassID(CL_VOLFOG_EFFECT, "VolFogEffect");

    if (root != NULL)
        this->loadParams(root);

    // Initialize Effect
    this->init();

    // Activate Effect
    this->activate();
}


VolFogEffect::~VolFogEffect() {
    this->deactivate();
}

void VolFogEffect::loadParams(const TiXmlElement* root) {
    WeatherEffect::loadParams(root);
}

void VolFogEffect::init() {
    PRINTF(3)("Initalize VolFogEffect\n");

    // set fog mode
    GLenum fogMode  = GL_EXP;

    // set fog density
    float  fogDensity  = 0.001f;

    // set fog near & far distance
    float fogStart = 0.0f;
    float fogEnd   = 1000.0f;

    // Set fog color
    float fogColor[4] = {0.6f,0.58f,0.79f,0.0f};


    /*    glFogCoordfEXT       = (PFNGLFOGCOORDFEXTPROC)glXGetProcAddressARB((const GLubyte*)"glFogCoordfEXT");
    glFogCoordfvEXT      = (PFNGLFOGCOORDFVEXTPROC)glXGetProcAddressARB((const GLubyte*)"glFogCoordfvEXT");
    glFogCoorddEXT       = (PFNGLFOGCOORDDEXTPROC)glXGetProcAddressARB((const GLubyte*)"glFogCoorddEXT");
    glFogCoorddvEXT      = (PFNGLFOGCOORDDVEXTPROC)glXGetProcAddressARB((const GLubyte*)"glFogCoorddvEXT");
    glFogCoordPointerEXT = (PFNGLFOGCOORDPOINTEREXTPROC)glXGetProcAddressARB((const GLubyte*)"glFogCoordPointerEXT");
    */
    // set the fog attributes
    glFogf (GL_FOG_START,  fogStart);
    glFogf (GL_FOG_END,    fogEnd);
    glFogfv(GL_FOG_COLOR,  fogColor);
    glFogi (GL_FOG_MODE,   fogMode);
    glFogf (GL_FOG_DENSITY,fogDensity);
    glFogi (GL_FOG_COORDINATE_SOURCE_EXT,GL_FOG_COORDINATE_EXT);

    // enable the fog
    glEnable(GL_FOG);

    if (glewInit() == GLEW_OK)
        PRINTF(4)("glewInit OK\n");
    else
        PRINTF(4)("glewInit failed\n");

    if (glewGetExtension("GL_EXT_fog_coord"))
        PRINTF(4)("GL_EXT_fog_coord extension found\n");
}


void VolFogEffect::activate() {
    PRINTF(3)("Activating VolFogEffect\n");
}

void VolFogEffect::deactivate() {
    PRINTF(3)("Deactivating VolFogEffect\n");

    glDisable(GL_FOG);
}


/**
* draws the effect, if needed
*/
void VolFogEffect::draw() const {
    glPushAttrib(GL_ENABLE_BIT);
    glClearColor(fogColor[0],fogColor[1],fogColor[2],0.0f);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glCullFace(GL_BACK);

    /* clear all pixels in colour buffer */
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    /* Enable blending */
    //glEnable(GL_BLEND);
    //glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);

    int i;
    glLoadIdentity();


    glBegin( GL_LINES );
    glNormal3f(0,1,0);
    for(i=-20;i<=20;i+=2) {
        float fog_c;
        float diff[3];

        diff[0] = State::getCameraNode()->getAbsCoor().x - i;
        diff[2] = State::getCameraNode()->getAbsCoor().z + 20;
        diff[1] = State::getCameraNode()->getAbsCoor().y;
        fog_c = 1.3f*sqrt(diff[0]*diff[0]+diff[1]*diff[1]+diff[2]*diff[2]);
        glFogCoordfEXT(fog_c*2);
        glVertex3f(i,0,-20);

        diff[0] = State::getCameraNode()->getAbsCoor().x - i;
        diff[2] = State::getCameraNode()->getAbsCoor().z + 20;
        diff[1] = State::getCameraNode()->getAbsCoor().y;
        fog_c = 1.3f*sqrt(diff[0]*diff[0]+diff[1]*diff[1]+diff[2]*diff[2]);
        glFogCoordfEXT(fog_c*2);
        glVertex3f(i,0,20);

        diff[0] = State::getCameraNode()->getAbsCoor().x - i;
        diff[2] = State::getCameraNode()->getAbsCoor().z + 20;
        diff[1] = State::getCameraNode()->getAbsCoor().y;
        fog_c = 1.3f*sqrt(diff[0]*diff[0]+diff[1]*diff[1]+diff[2]*diff[2]);
        glFogCoordfEXT(fog_c*2);
        glVertex3f(-20,0,i);

        diff[0] = State::getCameraNode()->getAbsCoor().x - i;
        diff[2] = State::getCameraNode()->getAbsCoor().z + 20;
        diff[1] = State::getCameraNode()->getAbsCoor().y;
        fog_c = 1.3f*sqrt(diff[0]*diff[0]+diff[1]*diff[1]+diff[2]*diff[2]);
        glFogCoordfEXT(fog_c*2);
        glVertex3f(20,0,i);
    }
    glEnd();

    glPopAttrib();

}


/**
* ticks the effect if there is any time dependancy
*/
void VolFogEffect::tick(float dt) {}
