/*!
 * @file proxy_settings.h
 *  some shared data from the proxy settings
 */

#ifndef _NETWORK_SETTINGS_H
#define _NETWORK_SETTINGS_H

#include "base_object.h"
#include "netdefs.h"

#include "debug.h"
#include "ip.h"

#include <vector>


class NetworkStream;
class Synchronizeable;
class TiXmlElement;


/* and here is the class itsself*/
class NetworkSettings : public BaseObject
{

  public:
    inline static NetworkSettings* getInstance() { if (!NetworkSettings::singletonRef) NetworkSettings::singletonRef = new NetworkSettings();
      return NetworkSettings::singletonRef; }
    virtual ~NetworkSettings();

    void loadData();

    void loadNetworkSettings(const TiXmlElement* root);

    /** @param number: sets the max number of players */
    inline void setMaxPlayer(int number) { this->maxPlayer = number; }
    /** @returns teh max number of players */
    int getMaxPlayer() { return this->maxPlayer; }
    /** sets the @param saturation: a threshold in percente when the proxy servers should be activated to be able to redirect the clients */
    inline void setMaxPlayerSaturation(float saturation) { this->maxPlayerSaturation = saturation; }


    void setMasterAddr(const std::string& masterAddr);
    /** @returns the address of the master server read from the network config file */
    inline IP getMasterAddr() { return this->masterServer; }

    void setProxyAddr(const std::string& proxyAddr);
    /** @returns the list of proxy servers from the init file */
    inline std::vector<IPaddress*>* getProxyList() { return &this->proxies; }


  private:
    NetworkSettings();


  private:
    static NetworkSettings*      singletonRef;            //!< Pointer to the only instance of this Class

    int                          maxPlayer;               //!< maximal number of players
    float                        maxPlayerSaturation;     //!< the saturation level from where on the proxy server should be activated

    std::vector<IPaddress*>      proxies;                 //!< all registered proxies
    IP                           masterServer;            //!< master server ip address

};



#endif /* _NETWORK_SETTINGS_H */
