/*!
 * @file net_link.h
 * @brief Definition of a NetLink class
 * NetLink is a File link to a page of file link to the Internet,
 * or the local file-system
 *
 * Opening a link should be made easy through this class
 *
 * !! DANGER IT IS POSSIBLE TO EXECUTE ALL PROGRAMMS WITH USER'S RIGHTS
 * !! ON THE DESIGNATED MACHINE
 * !! THIS CLASS SHOULD BE USED WITH CAUTION WHEN USING OVER IN NETWORK
 * !! MODE
 */

#ifndef __NET_LINK_H__
#define __NET_LINK_H__

#include <string>
#include <list>

#include "threading.h"

//! NetLink is a File and Link executer for Internet Links
/**
 * @example: NetLink("http://www.orxonox.net").openInBrowser();
 */
class NetLink
{
public:
  NetLink(const std::string& linkName);

  void openInBrowser() const;

  static void setDefaultBrowser(const std::string& browserName);
  static const std::string& defaultBrowser() {  return NetLink::_defaultBrowser; };

private:
  static int openupInBrowser(void* url);

  static std::list<std::string> buildBrowserList();


private:
  std::string                     _link;             //!< Linkname


  // static lists.
  static OrxThread::Mutex         _mutex;            //!< One mutex to lock them all.
  static std::string              _defaultBrowser;   //!< The default Browser.
  static std::list<std::string>   _browserList;
};

#endif /** __NET_LINK_H__ */
