

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

   bensch: renamed the file
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "physics_interface.h"
#include "physics_engine.h"

#include "field.h"
#include "p_node.h"

#include "string.h"
#include "stdincl.h"




/**
 *  standard constructor
 */
PhysicsInterface::PhysicsInterface ()
{
  this->setClassID(CL_PHYSICS_INTERFACE, "PhysicsInterface");

  this->mass = 1;
  this->massChildren = 0;
  this->forceSum = Vector(0, 0, 0);
  this->bForceApplied = false;
}

/**
 *  standard deconstructor
*/
PhysicsInterface::~PhysicsInterface ()
{
}

/**
 *  recalculates the total mass of all the children of this node

   (only availiable for PNodes)
*/
void PhysicsInterface::recalcMass()
{
  /*
    PNode* massCalcPNode = dynamic_cast<PNode*>(this);  //! @todo not sure if this will work ....
    float massSum = 0;

    tIterator<PNode>* iterator = massCalcPNode->children->getIterator();
    PNode* pn = iterator->firstElement();
    while( pn != NULL)
    {
    // todo: find out if children are PhysicsInterface in an efficient way
    if (strcmp( pn->getClassCName(), "PhysicsInterface")) {
    massSum += ((PhysicsInterface*)pn)->getTotalMass();
    }
    pn = iterator->nextElement();
    }
    delete iterator;

    if (massSum != this->massChildren ) {
    this->massChildren = massSum;
    if (strcmp( massCalcPNode->parent->getClassCName(), "PhysicsInterface"))
    ((PhysicsInterface*)massCalcPNode->parent)->recalcMass();
    } else {
    this->massChildren = massSum;
    }
  */
}

/**
 *  applyes a field to this Object
 * @param field the field to apply
 *
 * this function is virtual, and !must be reimplemented if the Member is !NOT! a PNode
*/
void PhysicsInterface::applyField(Field* field)
{
  PNode* tmp = dynamic_cast<PNode*>((BaseObject*)this);
  this->forceSum += field->calcForce(tmp->getAbsCoor());
  this->bForceApplied = true;
}

void PhysicsInterface::applyForce(const Vector& force)
{
  this->forceSum += force;
  this->bForceApplied = true;
}

/**
 *  ticks the PhysicsEffect
 * @param dt: the value about which to tick
*/
void PhysicsInterface::tickPhys( float dt )
{
  //  Vector acc = this->forceSum / ( this->massChildren + this->mass );
  PNode* coorTick =  dynamic_cast<PNode*>((BaseObject*)this);
  if (coorTick != NULL )
    coorTick->shiftCoor((coorTick->getVelocity()+ this->forceSum/this->mass*dt)*dt);

  if (this->bForceApplied)
  {
    this->bForceApplied = false;
    this->forceSum = Vector(0,0,0);
  }
}
