/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "physics_connection.h"

#include "physics_engine.h"

#include "field.h"
#include "particle_system.h"
#include "physics_interface.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"



CREATE_FACTORY(PhysicsConnection, CL_PHYSICS_CONNECTION);

/**
 *  creates a PhysicsConnection
*/
PhysicsConnection::PhysicsConnection(PhysicsInterface* subject, Field* field)
{
  this->setClassID(CL_PHYSICS_CONNECTION, "PhysicsConnection");
  this->type = PCON_PhysIField;

  this->subject = subject;
  this->field = field;

  PhysicsEngine::getInstance()->addConnection(this);
}

PhysicsConnection::PhysicsConnection(const TiXmlElement* root)
{
  this->setClassID(CL_PHYSICS_CONNECTION, "PhysicsConnection");
  this->type = PCON_PhysIField;

  BaseObject::loadParams(root);

  LoadParam(root, "subject", this, PhysicsConnection, setSubject)
      .describe("set the subject by a name");

  LoadParam(root, "field", this, PhysicsConnection, setField)
      .describe("set the field by name");

  PhysicsEngine::getInstance()->addConnection(this);
}

/**
 *  standard deconstructor

*/
PhysicsConnection::~PhysicsConnection ()
{
  PhysicsEngine::getInstance()->removeConnection(this);
}

/**
 * @param subjectName the name of the Subject for this PhysicsConnection
*/
void PhysicsConnection::setSubject(const std::string& subjectName)
{
  this->subject = PhysicsEngine::getInstance()->getPhysicsInterfaceByName(subjectName);
  if (this->subject == NULL)
  {
    PRINTF(2)("subject: (%s) not found for PhysicsConnection\n", subjectName.c_str());
  }
  else
    PRINTF(5)("subject::%s\n", this->subject->getCName());
}

/**
* @param fieldName the Name of the Field for this connection
*/
void PhysicsConnection::setField(const std::string& fieldName)
{
  this->field = PhysicsEngine::getInstance()->getFieldByName(fieldName);
  if (this->field == NULL)
  {
    PRINTF(2)("field: (%s) not found for PhysicsConnection\n", fieldName.c_str());
  }
  else
    PRINTF(5)("field::%s\n", this->field->getCName());

}

/**
  *  applies the Force to some Object.
*/
void PhysicsConnection::apply() const
{
  if (likely(this->type == PCON_PhysIField && this->field->getMagnitude() != 0.0
      && this->subject != NULL && this->field != NULL))
      this->subject->applyField(this->field);
  else ;
}
