/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "gui_saveable.h"
#include "gui.h"
#include "preferences.h"

#include "debug.h"

namespace OrxGui
{

  /**
   * standard constructor
  */
  Saveable::Saveable (const std::string& optionName, SaveableGroup* group, const MultiType& defaultValue)
  : BaseObject(optionName)
  {
    this->bSaveable = false;
    this->_defaultValue = defaultValue;

    assert(group != NULL);
    this->group = group;
    this->group->addSaveable(this);

  }


  /**
   * standard deconstructor
  */
  Saveable::~Saveable ()
  {
    this->group->removeSaveable(this);
    // delete what has to be deleted here
  }


  void Saveable::makeSaveable()
  {
    this->bSaveable = true;

  }


  void Saveable::load()
  {
    this->value() = Preferences::getInstance()->getMultiType(this->group->getCName(), this->getCName(), this->_defaultValue);
    PRINTF(4)("Loaded to '%s' of group '%s' value '%s'\n", this->getCName(), this->group->getCName(), this->value().getCString());
  }

  void Saveable::save()
  {
    Preferences::getInstance()->setMultiType(this->group->getCName(), this->getCName(), this->value() );
    PRINTF(4)("Saved to '%s' of group '%s' value '%s'\n", this->getCName(), this->group->getCName(), this->value().getCString());
  }




  SaveableGroup::SaveableGroup(const std::string& groupName, OrxGui::Gui* gui)
      : BaseObject(groupName)
  {
    assert (gui != NULL);
    this->gui = gui;

    this->gui->addSaveableGroup(this);
    //this->mainWidget = NULL;
  }



  SaveableGroup::~SaveableGroup()
  {
    this->gui->removeSaveableGroup(this);
  }


  /**
   * @brief Adds a Saveable to the List.
   * @param saveable the saveable to add.
   */
  void SaveableGroup::addSaveable(Saveable* saveable)
  {
    if (std::find(this->saveables.begin(), this->saveables.end(), saveable) == this->saveables.end())
      this->saveables.push_back(saveable);
  }

  /**
   * @brief Removes a Saveable from the List.
   * @param saveable the saveable to remove.
   */
  void SaveableGroup::removeSaveable(Saveable* saveable)
  {
    std::vector<Saveable*>::iterator delSav = std::find(this->saveables.begin(), this->saveables.end(), saveable);
    if (delSav != this->saveables.end())
      this->saveables.erase(delSav);
  }


  /**
   * @brief load the value onto the Group.
   * @param value the Value to load.
   */
  void SaveableGroup::load()
  {
    std::vector<Saveable*>::iterator elem;
    for (elem = this->saveables.begin(); elem != this->saveables.end(); ++elem)
      (*elem)->load();
  }

  /**
   * @brief save the value from the Group
   * @returns nothing.
   */
  void SaveableGroup::save()
  {
    std::vector<Saveable*>::iterator elem;
    for (elem = this->saveables.begin(); elem != this->saveables.end(); ++elem)
      (*elem)->save();
  }




}
