/*!
 * @file network_stats_widget.h
 * @brief Definition of an EnergyWidget, that displays a bar and a Text
*/

#ifndef _NETWORK_STATS_WIDGET_H
#define _NETWORK_STATS_WIDGET_H

#include "glgui_box.h"
#include "glgui_bar.h"
#include "glgui_text.h"

#include "network/ip.h"


namespace OrxGui
{

  class HostWidget : public GLGuiBox
  {
    public:
      HostWidget(const std::string& name, const IP& ip);
      ~HostWidget() {};

      void setName(const std::string& name) { this->_name.setText(name); };
      void setIP(const IP& ip) { this->_ip.setText(ip.ipString()); this->_storedIP = ip; };

      void setNameWidth(float width) { this->_name.setLineWidth(width); };

      bool operator==(const IP& ip) const { return (this->_storedIP == ip); };
      bool operator==(const std::string& name) const { return (this->_name == name); };

    protected:
      virtual void showing();
      virtual void hiding();

    private:
      GLGuiText        _name;           //!< The Name of the Proxy server to be displayed.
      GLGuiText        _ip;             //!< The IP of the proxy server.
      IP               _storedIP;       //!< The ip to compare.
  };


  class ProxyWidget : public GLGuiBox
  {
    public:
      ProxyWidget(const std::string& proxyName, const IP& ip);

      void addClient(const std::string& name, const IP& ip);

      bool removeClient(const IP& ip);
      bool removeClient(const std::string& name);
      bool removeClient(const std::string& name, const IP& ip);


    protected:
      virtual void hiding();
      virtual void showing();


    private:
      HostWidget       _proxyWidget;

      std::vector<HostWidget*>  _clients;
  };




  //! A class to display network Statistics.
  class NetworkStatsWidget : public GLGuiBox
  {
    public:
      NetworkStatsWidget();
      virtual ~NetworkStatsWidget();

      void setUpstream(unsigned int upstream);
      void setDownstream(unsigned int upstream);
      void setIP(const IP& ip);



      //void rebuildConnectedHosts(std::vector<hosts> hosts);

      void setMaximum(float max);
      void setValue(float value);

    protected:
      virtual void resize();
      virtual void showing();
      virtual void hiding();

    private:
      IP                     _ip;
      GLGuiText              _ipText;

      GLGuiText              _upstreamText;
      GLGuiText              _downstreamText;

      std::vector<GLGuiText> _connectedHosts;

      GLGuiText              _serverIP;


      GLGuiText              _valueText;
      GLGuiBar               _bar;
  };
}
#endif /* _NETWORK_STATS_WIDGET_H */
