
/*!
 * @file ip.h
 *
 * @brief the ip class is used to transform strings to ip's and backwards
 * it can also be used to
 */

#ifndef __IP_H__
#define __IP_H__

#include "netdefs.h"
#include <string>



//! A class to handle time itself
class IP
{
  public:
    /// CONSTRUCTORS
    IP();
    IP(int ip, int port);
    IP(const std::string& ip, bool resolve = true);
    IP(const std::string& ip, int port = -1, bool resolve = true);
    IP(const IPaddress& ip);
    IP(const IP& ip);

    /// OPERATORS
    const IP& operator=(const IP& ip);
    const IP& operator=(const IPaddress& ip);
    bool operator==(const IP& ip) const;
    bool operator!=(const IP& up) const;

    /// RETRIVEAL
    /** @returns the IP */
    int host() const { return this->_ip; };
    int* hostRef()  { return &this->_ip; }
    /** @returns the Port */
    int port() const { return this->_port; };
    int* portRef() { return &this->_port; };

    inline IPaddress getSDLNotation() { IPaddress sdlIP; sdlIP.host = this->_ip; sdlIP.port = this->_port; return sdlIP; }

    int ipPart(unsigned int part) const;
    std::string ipString() const;

    void debug() const;

  public:
    /// SETUP
    static IP stringToIP(const std::string& ip, int port = -1, bool resolve = true);

    static std::string ipToString(const IPaddress& ipaddr);
    static std::string ipToString(int ip, int port = -1);

    static void setDefaultPort(int defaultPort);
    static int defaultPort(int defaultPort) { return IP::_defaultPort; };

  private:
    int           _ip;           //!< The IP in int form.
    int         _port;         //!< The Port number of the IP

    static int  _defaultPort;  //!< Default Port
};

#endif /* __IP_H__ */
