/*!
 * @file glgui_textfield.h
 * The gl_TEXTFIELD widget of th openglGUI
 *
 */

#ifndef _GLGUI_TEXTFIELD_H
#define _GLGUI_TEXTFIELD_H

#include "glgui_widget.h"
#include "multi_line_text.h"
// FORWARD DECLARATION
namespace OrxGui
{

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiTextfield : public GLGuiWidget
  {

  public:
    GLGuiTextfield();
    virtual ~GLGuiTextfield();

    void setText(const std::string& text);
    void append(const std::string& appendText);
    void appendCharacter(char character);
    void removeCharacters(unsigned int chars);
    void clear();

    void setChangedTextColor(const Color& color);

    const std::string& text() const { return _text.text(); };


    virtual void draw() const;

    sigslot::signal1<const std::string&> textChanged;

  protected:
    virtual void updateFrontColor();
    virtual void hiding();
    virtual void showing();
    virtual void resize();

  private:
    void init();
    void changedText();


  private:
    MultiLineText      _text;

    Color               _changedTextColor;
  };
}

#endif /* _GLGUI_TEXTFIELD_H */
