/*!
 * @file glgui_text.h
 * The gl_TEXT widget of th openglGUI
 *
 */

#ifndef _GLGUI_TEXT_H
#define _GLGUI_TEXT_H

#include "glgui_widget.h"
#include "limited_width_text.h"
// FORWARD DECLARATION
namespace OrxGui
{

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiText : public GLGuiWidget
  {

  public:
    GLGuiText();
    virtual ~GLGuiText();

    void setText(const std::string& text);
    void append(const std::string& appendText);
    void appendCharacter(char character);
    void removeCharacters(unsigned int chars);
    void clear();

    void setChangedTextColor(const Color& color);

    void setDotsPosition(LimitedWidthText::DotsPosition dotsPosition) { this->_text.setDotsPosition(dotsPosition); };

    const std::string& text() const { return _text.text(); };


    virtual void draw() const;

    sigslot::signal1<const std::string&> textChanged;

  protected:
    virtual void updateFrontColor();
    virtual void hiding();
    virtual void showing();
    virtual void resize();

  private:
    void init();
    void changedText();


  private:
    LimitedWidthText    _text;

    Color               _changedTextColor;
  };
}

#endif /* _GLGUI_TEXT_H */
