/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "cmd_line_prefs_reader.h"

#include "preferences.h"



RegistredArgs CmdLinePrefsReader::regArgs;

/**
 * standard constructor
*/
CmdLinePrefsReader::CmdLinePrefsReader( )
{

}


/**
 * standard deconstructor
*/
CmdLinePrefsReader::~CmdLinePrefsReader ()
{
}

bool CmdLinePrefsReader::callBack( ArgTableEntry entry, void * data, const std::string & arg, const std::vector<MultiType> & argArgs )
{
  CallbackData * cbd = (CallbackData *)data;

  switch ( entry.id )
  {
    case ID_SET_INI:
    {
      std::string section = arg;
      section.erase( 0, entry.longOption.length()+1 );
      std::string key = section;
      section.erase( section.find(".") );
      key.erase( 0, key.find(".")+1 );
      //PRINTF(0)("SECTION '%s', KEY '%s'\n", section.c_str(), key.c_str());

      if ( key == "" || section == "" || argArgs.size() != 1 )
      {
        PRINTF(1)("usage: --set-section.key=value\n");
        return false;
      }

      //Preferences::getInstance()->setMultiType( section, key, argArgs[0], true );
      cbd->iniEntries.push_back( IniEntry() );
      cbd->iniEntries.back().section = section;
      cbd->iniEntries.back().key = key;
      cbd->iniEntries.back().value = argArgs[0].getString();
      return true;
    }
    case ID_HELP:
      cbd->parser->showHelp();
      return true;
  }

  if ( entry.id >= ID_PREFS && entry.id  < regArgs.size() + ID_PREFS)
  {
    if ( regArgs[entry.id - ID_PREFS].value == "%arg%" )
    {
      assert( argArgs.size() == 1 );

      cbd->iniEntries.push_back( IniEntry() );
      cbd->iniEntries.back().section = regArgs[entry.id - ID_PREFS].section;
      cbd->iniEntries.back().key = regArgs[entry.id - ID_PREFS].key;
      cbd->iniEntries.back().value = argArgs[0].getString();
    }
    else
    {
      cbd->iniEntries.push_back( IniEntry() );
      cbd->iniEntries.back().section = regArgs[entry.id - ID_PREFS].section;
      cbd->iniEntries.back().key = regArgs[entry.id - ID_PREFS].key;
      cbd->iniEntries.back().value = regArgs[entry.id - ID_PREFS].value;
    }
  }
  else
  {
    assert(false);
  }

  return true;
}


bool CmdLinePrefsReader::parse( int argc, char ** argv )
{
  CmdLineParser parser;

  parser.add( ID_HELP, "help", 'h', 0, "", "Shows this help and exits");

  for (unsigned int i = 0; i<regArgs.size(); i++ )
  {
    if ( regArgs[i].value == "%arg%" )
    {
      parser.add( ID_PREFS + i, regArgs[i].longOption, regArgs[i].shortOption, 1, regArgs[i].argName, regArgs[i].help );
    }
    else
    {
      parser.add( ID_PREFS + i, regArgs[i].longOption, regArgs[i].shortOption, 0, "", regArgs[i].help );
    }
  }

  parser.add( ID_SET_INI, "set-%", '\0', 1, "value", "Override a configuration element." );

  CallbackData cbd;

  cbd.parser = &parser;

  if ( parser.parse( &callBack, &cbd, argc, argv ) )
  {
    std::list<IniEntry>::const_iterator it;
    for ( it = cbd.iniEntries.begin(); it != cbd.iniEntries.end(); it++ )
    {
      Preferences::getInstance()->setString( it->section, it->key, it->value, true);
    }
  }
  else
  {
    exit(EXIT_FAILURE);
  }

  return true;
}

bool CmdLinePrefsReader::registerArgument( const char shortOption, const std::string & longOption, const std::string & section, const std::string & key, const std::string & help, const std::string & argName, const std::string & value )
{
  RegistredArgument arg;

  arg.longOption = longOption;
  while ( arg.longOption.find("_") != std::string::npos )
  {
    arg.longOption.replace( arg.longOption.find("_"), 1, "-" );
  }
  arg.shortOption = shortOption;
  if ( arg.shortOption == '_' )
    arg.shortOption = '\0';
  arg.value = value;
  arg.help = help;
  arg.argName = argName;
  arg.section = section;
  arg.key = key;

  regArgs.push_back( arg );
  return true;
}


