/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "image_plane.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "graphics_engine.h"
#include "glincl.h"
#include "p_node.h"





CREATE_FACTORY(ImagePlane, CL_IMAGE_ENTITY);


/**
 * standart constructor
 */
ImagePlane::ImagePlane (const TiXmlElement* root)
{
  this->init();

  if( root)
    this->loadParams(root);
}


/**
 * destroys a ImagePlane
 */
ImagePlane::~ImagePlane ()
{
}


/**
 * initializes the ImagePlane
 */
void ImagePlane::init()
{
  this->setClassID(CL_IMAGE_PLANE, "ImagePlane");
  this->setName("ImagePlane");

  this->setLayer(E2D_LAYER_TOP);
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0, GraphicsEngine::getInstance()->getResolutionY()/10.0);

  //this->setBindNode(this);
  this->setTexture("pictures/error_texture.png");
}


/**
 *  load params
 * @param root TiXmlElement object
 */
void ImagePlane::loadParams(const TiXmlElement* root)
{
  LoadParam(root, "texture", &this->material, Material, setDiffuseMap)
      .describe("the texture-file to load onto the ImagePlane");

  LoadParam(root, "size", this, ImagePlane, setSize)
      .describe("the size of the ImagePlane in Pixels");
}


/**
 * sets the size of the ImagePlane.
 * @param size the size in pixels
 */
void ImagePlane::setSize(float sizeX, float sizeY)
{
  this->setSize2D(sizeX, sizeY);
}


/**
 * sets the material to load
 * @param textureFile The texture-file to load onto the crosshair
 */
void ImagePlane::setTexture(const std::string& textureFile)
{
  this->material.setDiffuseMap(textureFile);
}


/**
 * attaches this image_plane to a parent
 * @param pNode node to attach to
 */
void ImagePlane::attachTo(PNode* pNode)
{
  this->source->setParent(pNode);
}


/**
 * ticks the ImagePlane
 * @param dt the time to ticks
 */
void ImagePlane::tick(float dt)
{
  float z = 0.0f;
  glReadPixels ((int)this->getAbsCoor2D().x,
                 GraphicsEngine::getInstance()->getResolutionY()-(int)this->getAbsCoor2D().y-1,
                 1,
                 1,
                 GL_DEPTH_COMPONENT,
                 GL_FLOAT,
                 &z);

  GLdouble objX=.0, objY=.0, objZ=.0;
  gluUnProject(this->getAbsCoor2D().x,
               GraphicsEngine::getInstance()->getResolutionY()-this->getAbsCoor2D().y-1,
               .99,  // z
               GraphicsEngine::modMat,
               GraphicsEngine::projMat,
               GraphicsEngine::viewPort,
               &objX,
               &objY,
               &objZ );
}


/**
 * draws the image_plane
 */
void ImagePlane::draw() const
{
  glPushMatrix();

  glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0);
  this->material.select();

  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2f(0, 0);
  glVertex2f(-this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(1, 0);
  glVertex2f(this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(0, 1);
  glVertex2f(-this->getSizeX2D(), this->getSizeY2D());
  glTexCoord2f(1, 1);
  glVertex2f(this->getSizeX2D(), this->getSizeY2D());
  glEnd();

  glPopMatrix();
}
