/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_DETECTION

#include "cd_engine.h"
#include "obb_tree.h"
#include "debug.h"

#include "class_list.h"

#include "model.h"
#include "world_entity.h"
#include "terrain.h"
// #include "player.h"

#include "spatial_separation.h"
#include "quadtree.h"
#include "quadtree_node.h"

#include "bsp_manager.h"
#include "bsp_entity.h"




/**
 *  standard constructor
 */
CDEngine::CDEngine ()
{
  this->setClassID(CL_CD_ENGINE, "CDEngine");

  this->bAbordOnFirstCollision = false;
  
  this->terrain = NULL;
}


/**
 *  the singleton reference to this class
 */
CDEngine* CDEngine::singletonRef = NULL;


/**
 *  standard deconstructor
 */
CDEngine::~CDEngine ()
{
  CDEngine::singletonRef = NULL;
}


/**
 *
 */
void CDEngine::checkCollisions(ObjectManager::EntityList& list1, ObjectManager::EntityList& list2)
{
  BVTree* tree;
  ObjectManager::EntityList::iterator entity1, entity2, pre1, pre2;
  PRINTF(5)("checking for collisions\n");

  pre1 = list1.begin();
  while (pre1 != list1.end())
  {
    entity1 = pre1++;
    if( likely((*entity1) != this->terrain))
    {
      pre2 = list2.begin();
      while (pre2 != list2.end())
      {
        entity2 = pre2++;
        if( likely((*entity2) != this->terrain))
        {
          PRINTF(5)("checking object %s (%s) against %s (%s)\n", (*entity1)->getClassName(), (*entity1)->getName(), (*entity2)->getClassName(), (*entity2)->getName());
          tree = (*entity1)->getOBBTree();
          if( likely(tree != NULL) && (*entity2)->getOBBTree() != NULL)
            tree->collideWith(*entity1, *entity2);
        }
      }
    }
  }
}


/**
 *  this checks the collisions with the ground
 */
void CDEngine::checkCollisionGround(std::list<WorldEntity*>& list1)
{

  std::list<BaseObject*>::const_iterator bspIterator;
  std::list<WorldEntity*>::iterator entityIterator;
  const std::list<BaseObject*>* bspList = ClassList::getList(CL_BSP_ENTITY);
  if( bspList == NULL)
    return;

  // for all bsp managers check all entities
  for( bspIterator = bspList->begin(); bspIterator != bspList->end(); bspIterator++) {
      for(entityIterator = list1.begin(); entityIterator != list1.end(); entityIterator++)
      {
//         PRINTF(0)("Checking: %s a %s\n", (*entityIterator)->getName(), (*entityIterator)->getClassName());
        (dynamic_cast<BspEntity*>(*bspIterator)->getBspManager())->checkCollision(*entityIterator);
      }
  }
}


/**
 * some debug output on the class
 */
void CDEngine::debug()
{
  PRINT(0)("\n=============================| CDEngine::debug() |===\n");
  PRINT(0)("=  CDEngine: Spawning Tree Start\n");
  //this->rootTree->debug();
  PRINT(0)("=  CDEngine: Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");
}


/**
 * this spawns a tree for debug purposes only
 */
void CDEngine::debugSpawnTree(int depth, sVec3D* vertices, int numVertices)
{
//   if ( this->rootTree == NULL)
//     this->rootTree = new OBBTree(depth, vertices, numVertices);
}


void CDEngine::drawBV(const ObjectManager::EntityList& drawList, int level) const
{
  ObjectManager::EntityList::const_iterator entity;
  for (entity = drawList.begin(); entity != drawList.end(); entity++)
    (*entity)->drawBVTree(level, 226);
}


/**
 * this draws the debug spawn tree
 */
void CDEngine::debugDraw(int depth, int drawMode)
{
//   if(this-> rootTree != NULL)
//     this->rootTree->drawBV(depth, drawMode);
}
