/*!
 * @file network_stats_widget.h
 * @brief Definition of an EnergyWidget, that displays a bar and a Text
*/

#ifndef _NETWORK_STATS_WIDGET_H
#define _NETWORK_STATS_WIDGET_H

#include "glgui_box.h"
#include "glgui_bar.h"
#include "glgui_text.h"

#include "network/ip.h"


namespace OrxGui
{

  //! A class to display network Statistics.
  class NetworkStatsWidget : public GLGuiBox
  {

  public:
    NetworkStatsWidget();
    virtual ~NetworkStatsWidget();

    void setUpstream(unsigned int upstream);
    void setDownstream(unsigned int upstream);
    void setIP(const IP& ip);



    //void rebuildConnectedHosts(std::vector<hosts> hosts);

    void setMaximum(float max);
    void setValue(float value);

  protected:
    virtual void resize();
    virtual void showing();
    virtual void hiding();

  private:
    IP                     _ip;
    GLGuiText              _ipText;

    GLGuiText              _upstreamText;
    GLGuiText              _downstreamText;

    std::vector<GLGuiText> _connectedHosts;

    GLGuiText              _serverIP;


    GLGuiText              _valueText;
    GLGuiBar               _bar;
  };
}
#endif /* _NETWORK_STATS_WIDGET_H */
