/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "network_stats_widget.h"

namespace OrxGui
{
  /**
   * @brief standard constructor
   */
  NetworkStatsWidget::NetworkStatsWidget ()
  {
    //   this->setClassID(CL_PROTO_ID, "NetworkStatsWidget");

    this->_bar.setSize2D(100, 30);
    this->pack(&this->_valueText);
    this->_bar.setParent2D(&this->_valueText);

    this->_valueText.setChangedTextColor(Color::white);

    //this->setBackgroundTexture("maps/gui_element_background_2.png");
    this->setBackgroundColor(Color(.5,.5,.5,1));

    //this->_name.setBackgroundTexture(Texture());
    //this->_valueText.setBackgroundTexture("maps/gui_element_background_2.png");
    this->_bar.setBackgroundTexture(Texture());
    this->_bar.setBackgroundColor(Color(0,0,0,0));
    this->_bar.setForegroundTexture("maps/gui_element_background_faded.png");
    this->_bar.setForegroundColor(Color(.5, .5, .5, 1));
    this->_bar.setChangedValueColor(Color::black);
  }


  /**
   * @brief standard deconstructor
   */
  NetworkStatsWidget::~NetworkStatsWidget ()
  {
  }


  void NetworkStatsWidget::setMaximum(float max)
  {
    this->_bar.setMaximum(max);
  }

  void NetworkStatsWidget::setValue(float value)
  {
    MultiType val(value);
    val.setType(MT_INT);


    this->_bar.setValue(value);
    this->_bar.setForegroundColor(Color::slerpHSVColor(Color::red, Color::green, value/this->_bar.maximum()));
    this->_bar.setFrontColor(Color(1,1,1,1), true);
    this->_valueText.setText(val.getString());
  }

  void NetworkStatsWidget::resize()
  {
    GLGuiBox::resize();
  }


  void NetworkStatsWidget::showing()
  {
    this->_valueText.show();
    this->_bar.show();
  }

  void NetworkStatsWidget::hiding()
  {
    this->_valueText.hide();
    this->_bar.hide();
  }
}
