/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_MODULE_GAME_RULES

#include "game_rules.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "util/mission_goal.h"

#include "shared_network_data.h"

#include "debug.h"


using namespace std;


/**
 * constructor
 */
GameRules::GameRules(const TiXmlElement* root)
{
  this->setClassID(CL_GAME_RULES, "GameRules");
}

/**
 * decontsructor
 */
GameRules::~GameRules()
{}



void GameRules::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);

  PRINTF(0)("GameRules::loadParams(...) hit me\n");
  LoadParamXML(root, "MissionGoal", this, GameRules, loadMissionGoal)
      .describe("an XML-Element to load the missions from");
}



void GameRules::loadMissionGoal(const TiXmlElement* root)
{
  PRINTF(0)("Trying to load MissionGoals\n");
  const TiXmlElement* element = root->FirstChildElement();
  while( element != NULL)
  {
    PRINTF(4)("============ MissionGoal\n");
    PRINTF(4)("Adding Mission Goal:%s\n", element->Value());
    BaseObject* created = Factory::fabricate(element);
    if (created != NULL /*&& created->isA(CL_GAME_RULES)*/)
    {
      MissionGoal* mg = dynamic_cast<MissionGoal*>(created);
      this->addMissionGoal(mg);
      // if there is a valid game rule loaded, break because it is not thought to load multiple game rules
      break;
    }
    else
    {
      PRINTF(1)("Could not create a %s\n", element->Value());
      delete created;
    }
    element = element->NextSiblingElement();
  }
}

/**
 * adding a kill event to the kill list
 * @param kill the kill object containing all infos
 */
void GameRules::registerKill(const Kill& kill)
{
  if ( !SharedNetworkData::getInstance()->isMasterServer() )
    return;

  PRINTF(0)("Received Event: Kill\n");

  this->killList.push_back( kill );
}

