/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   */

/*!
 * @file functors_list.h
 * all the Different types of Functions one can include
*/

/**
   useable FunctionParameters are:
   l_INT:       int
   l_LONG:      long
   l_SHORT:     short
   l_FLOAT:     float
   l_STRING:    const std::string&
   l_XML_ELEM:  TiXmlElement*
 */

#ifndef __FUNCTOR_PARAMETERS__
#define __FUNCTOR_PARAMETERS__

//! defines the maximum count of arguments function pointers might have
#define FUNCTOR_MAX_ARGUMENTS                7
#include "multi_type.h"


#define l_BOOL_TYPE        bool                 //!< The type of an BOOL
#define l_BOOL_FUNC        isBool               //!< The function to call to parse BOOL
#define l_BOOL_PARAM       MT_BOOL              //!< the type of the parameter BOOL
#define l_BOOL_DEFAULT     false                //!< a default Value for an BOOL
#define l_BOOL_DEFGRAB(i)  this->defaultValue[i].getBool()

#define l_INT_TYPE         int                  //!< The type of an INT
#define l_INT_FUNC         isInt                //!< The function to call to parse INT
#define l_INT_PARAM        MT_INT               //!< the type of the parameter INT
#define l_INT_DEFAULT      0                    //!< a default Value for an INT
#define l_INT_DEFGRAB(i)   this->defaultValue[i].getInt()

#define l_UINT_TYPE        unsigned int         //!< The type of an UINT
#define l_UINT_FUNC        isInt                //!< The function to call to parse UINT
#define l_UINT_PARAM       MT_INT        //!< the type of the parameter UINT
#define l_UINT_DEFAULT     0                    //!< a default Value for an UINT
#define l_UINT_DEFGRAB(i)  (unsigned int)this->defaultValue[i].getInt()

#define l_LONG_TYPE        long                 //!< The type of a LONG
#define l_LONG_FUNC        isInt                //!< The function to parse a LONG
#define l_LONG_PARAM       MT_INT //!< the type of the parameter LONG
#define l_LONG_DEFAULT     0                    //!< a default Value for a LONG
#define l_LONG_DEFGRAB(i)  (long)this->defaultValue[i].getInt()

// #define l_SHORT_TYPE       short                //!< The type of a SHORT
// #define l_SHORT_FUNC       atoi                 //!< The function to parse a SHORT
// #define l_SHORT_NAME       "short"              //!< The name of a SHORT
// #define l_SHORT_PARAM      ParameterShort       //!< the type of the parameter SHORT
// #define l_SHORT_DEFAULT    0                    //!< a default Value for a SHORT

#define l_FLOAT_TYPE       float                //!< The type of a FLOAT
#define l_FLOAT_FUNC       isFloat              //!< The function to parse a FLOAT
#define l_FLOAT_PARAM      MT_FLOAT             //!< the type of the parameter FLOAT
#define l_FLOAT_DEFAULT    0.0                  //!< a default Value for a FLOAT
#define l_FLOAT_DEFGRAB(i) this->defaultValue[i].getFloat()

//#define l_VECTOR_TYPE      const Vector&        //!< The type of a VECTOR
//#define l_VECTOR_FUNC      isVector             //!< The function to parse a VECTOR
//#define l_VECTOR_NAME      "Vector[x/y/z]"      //!< The name of a VECTOR
//#define l_VECTOR_DEFAULT   Vector(0,0,0)        //!< Default value for a VECTOR

#define l_STRING_TYPE      const std::string&   //!< The type of a STRING
#define l_STRING_FUNC      isString             //!< The function to parse a STRING
#define l_STRING_PARAM     MT_STRING            //!< the type of the parameter STRING
#define l_STRING_DEFAULT   ""                   //!< a default Value for an STRING
#define l_STRING_DEFGRAB(i) this->defaultValue[i].getString()

#define l_XML_ELEM_TYPE    const TiXmlElement*  //!< The type of an XML_ELEM
#define l_XML_ELEM_FUNC                         //!< The function to parse an XML_ELEM
//#define l_XML_ELEM_PARAM   Parameter            //!< the type of the parameter XML_ELEM
#define l_XML_ELEM_DEFAULT NULL                 //!< The dafault Value for an XML_ELEM

#endif /* __FUNCTOR_PARAMETERS__ */


#ifdef FUNCTOR_LIST

  FUNCTOR_LIST(0)();
  //! makes functions with one string
  FUNCTOR_LIST(1)(l_STRING);
  //! makes functions with two strings
  FUNCTOR_LIST(2)(l_STRING, l_STRING);
  //! makes functions with three strings
  FUNCTOR_LIST(3)(l_STRING, l_STRING, l_STRING);
  //! makes functions with four strings
  FUNCTOR_LIST(4)(l_STRING, l_STRING, l_STRING, l_STRING);


  //! makes functions with one bool
  FUNCTOR_LIST(1)(l_BOOL);

  //! makes functions with one int
  FUNCTOR_LIST(1)(l_INT);
  //! makes functions with two ints
  FUNCTOR_LIST(2)(l_INT, l_INT);
  //! makes functions with three ints
  FUNCTOR_LIST(3)(l_INT, l_INT, l_INT);
  //! makes functions with four ints
  FUNCTOR_LIST(4)(l_INT, l_INT, l_INT, l_INT);


  //! makes functions with one unsigned int
  FUNCTOR_LIST(1)(l_UINT);
  //! makes functions with two unsigned ints
  FUNCTOR_LIST(2)(l_UINT, l_UINT);
  //! makes functions with three unsigned ints
  FUNCTOR_LIST(3)(l_UINT, l_UINT, l_UINT);
  //! makes functions with four unsigned ints
  FUNCTOR_LIST(4)(l_UINT, l_UINT, l_UINT, l_UINT);

  //! makes functions with one float
  FUNCTOR_LIST(1)(l_FLOAT);
  //! makes functions with two floats
  FUNCTOR_LIST(2)(l_FLOAT, l_FLOAT);
  //! makes functions with three floats
  FUNCTOR_LIST(3)(l_FLOAT, l_FLOAT, l_FLOAT);
  //! makes functions with four floats
  FUNCTOR_LIST(4)(l_FLOAT, l_FLOAT, l_FLOAT, l_FLOAT);
  //! makes functions with four floats
  FUNCTOR_LIST(5)(l_FLOAT, l_FLOAT, l_FLOAT, l_FLOAT, l_FLOAT);

  //! mixed values:
  FUNCTOR_LIST(2)(l_STRING, l_INT);
  FUNCTOR_LIST(2)(l_STRING, l_FLOAT);
  FUNCTOR_LIST(2)(l_UINT, l_LONG);
  FUNCTOR_LIST(2)(l_STRING, l_UINT);

  FUNCTOR_LIST(3)(l_STRING, l_FLOAT, l_UINT);
  FUNCTOR_LIST(4)(l_STRING, l_FLOAT, l_UINT, l_UINT);
  FUNCTOR_LIST(3)(l_STRING, l_INT, l_UINT);
  FUNCTOR_LIST(3)(l_STRING, l_UINT, l_UINT);

  FUNCTOR_LIST(5)(l_FLOAT, l_FLOAT, l_FLOAT, l_FLOAT, l_STRING);

#endif /* FUNCTOR_LIST */
