/*!
 * @file upd_socket.h
 *  class to connect to other clients via udp
 */

#ifndef _UDP_SOCKET
#define _UDP_SOCKET

/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "network_socket.h"

class UdpServerSocket;

enum
{
  UDPCMD_DISCONNECT = 1,
  UDPCMD_INVALIDRNDBYTE = 2
};

class UdpSocket : public NetworkSocket
{
  public:
    UdpSocket();
    UdpSocket( UdpServerSocket * serverSocket, IPaddress ip, int userId, byte randomByte );
    UdpSocket( std::string host, int port );
    virtual ~UdpSocket();

    virtual void connectToServer( std::string host, int port );
    virtual void disconnectServer();

    virtual void reconnectToServer( std::string host, int port);
    virtual void reconnectToServerSoft( std::string host, int port);

    virtual bool writePacket(byte * data, int length );
    virtual int readPacket(byte * data, int maxLength);


  private:
    UdpServerSocket * serverSocket;   //!< will get packets here
    int               userId;         //!< user id used by serverSocket
    UDPsocket         socket;         //!< socket used to send/recieve
    UDPpacket *       packet;

    byte              randomByte;     //!< contains random bytes & 0xFC

    bool writeRawPacket( byte * data, int length );
    bool checkUdpCmd( byte udpCmd );
    bool checkRandomByte( byte rndByte );
    byte generateNewRandomByte();

    void init();

};



#endif /* _NETWORK_SOCKET */
