/*!
 * @file tcp_socket.h
  *  tcp socket network interface

*/

#ifndef _TCP_SOCKET
#define _TCP_SOCKET

//TODO HACK else gdb will not work on server
#define DONTEXITTHREADS

//if you want to use outgoing buffer define _USE_OUTGOING_BUFFER
#define _USE_OUTGOING_BUFFER

#define _INCOMING_BUFFER_SIZE 2024000
#define _OUTGOING_BUFFER_SIZE 2024000
#define _LOCAL_BUFFER_SIZE 1024
//sleep if incoming buffer is full
#define _MSECONDS_SLEEP_FULL_BUFFER 10
//sleep if outgoing buffer is empty
#define _MSECONDS_SLEEP_EMPTY_BUFFER 10


/* contains memmove and memcpy */
#include <string.h>

#ifdef HAVE_SDL_H
#include <SDL_thread.h>
#else
#include <SDL/SDL_thread.h>
#endif
/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include network_socket.h since all classes are derived from this one */
#include "network_socket.h"

class TcpSocket : public NetworkSocket
{
  public:
    TcpSocket();
    TcpSocket( std::string host, int port );
    TcpSocket(TCPsocket sock);
    virtual ~TcpSocket();

    virtual void connectToServer( std::string host, int port );

    virtual void disconnectServer();
    virtual void reconnectToServer( std::string host, int port);
    virtual void reconnectToServerSoft( std::string host, int port);

    virtual bool writePacket(byte * data, int length);

    virtual int readPacket(byte * data, int maxLength);

  private:
    TCPsocket tcpSocket;

    byte incomingBuffer[_INCOMING_BUFFER_SIZE];
#ifdef _USE_OUTGOING_BUFFER
  byte outgoingBuffer[_OUTGOING_BUFFER_SIZE];
#endif
  int incomingBufferLength;
#ifdef _USE_OUTGOING_BUFFER
  int outgoingBufferLength;
#endif

  SDL_mutex * incomingBufferMutex;
#ifdef _USE_OUTGOING_BUFFER
  SDL_mutex * outgoingBufferMutex;
#endif
  SDL_mutex * socketMutex;
  bool terminateThread;

  SDL_mutex* threadTerminationMutex;
  static int thread_read(void * data);
  bool thread_read_running;
  bool thread_write_running;

  SDL_Thread*            readThread;
  SDL_Thread*            writeThread;

#ifdef _USE_OUTGOING_BUFFER
  static int thread_write(void * data);
#endif

  int writeBytes(byte * data, int length);
  int readBytes(byte * data, int length);
  int readBlock(byte * data, int length);

  void init();

};



#endif /* _NETWORK_SOCKET */
