/*!
 * @file server_socket.h
 *  waits for incoming connections

 */

#ifndef _TCP_SERVER_SOCKET
#define _TCP_SERVER_SOCKET

/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "base_object.h"
#include "server_socket.h"


class TcpServerSocket : public ServerSocket
{
  public:
    TcpServerSocket( int port );

    virtual ~TcpServerSocket();

    virtual bool listen( unsigned int port );
    virtual NetworkSocket* getNewSocket( void );
    virtual void close();
    virtual void update() {};

  private:
    TCPsocket listenSocket;
    bool terminateThread;

    bool _isListening;

    void init();

};

#endif
