/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/


#include "synchronizeable_ip.h"
#include "converter.h"
// #include "ip.h"

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableIP::SynchronizeableIP( IP * ptrIn, IP * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 2*INTSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableIP::~SynchronizeableIP ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableIP::writeToBuf( byte * buf, int maxLength )
{
  int n = 0;
  int res;

  res = Converter::intToByteArray( (int)vPtrIn->host(), buf, maxLength );
  assert(res > 0);
  n += res;

  res = Converter::intToByteArray( (int)vPtrIn->port(), buf, maxLength);
  assert(res > 0);
  n += res;

  assert( 2 * INTSIZE == n);

  return n;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableIP::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= 2 * INTSIZE);

  int host, port;

  int res;
  int n = 0;

  IP oldVal = *vPtrOut;

  res = Converter::byteArrayToInt( buf + n, &host);
  assert( res > 0);
  n += res;


  res = Converter::byteArrayToInt( buf + n, &port);
  assert( res > 0);
  n += res;

  *this->vPtrOut = IP(host, port);

  printf(" vtrp out old: %i, %i -- new: %i, %i\n", oldVal.host(), oldVal.port(), this->vPtrOut->host(), this->vPtrOut->port());
  setHasChanged( *this->vPtrOut != oldVal);

  assert( n == 2 * INTSIZE);

  return n;
}


/**
 * print out variable value
 */
void SynchronizeableIP::SynchronizeableIP::debug( )
{
  printf("SYNCHRONIZEABLE_VAR: %s IN: %i, %i OUT: %i, %i\n", name.c_str(), vPtrIn->host(), vPtrIn->port(), vPtrOut->host(), vPtrOut->port());
}

