/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/


#define DEBUG_MODULE_NETWORK

#include "proxy_settings.h"
#include "netdefs.h"

#include "loading/load_param.h"


using namespace std;


ProxySettings* ProxySettings::singletonRef = NULL;

/**
 * Standard constructor
 */
ProxySettings::ProxySettings()
{
  /* set the class id for the base object */
  this->setClassID(CL_PROXY_SETTINGS, "ProxySettings");
  // suggest a good standard max players value
  this->maxPlayer = 10;
}


/**
 * Standard destructor
 */
ProxySettings::~ProxySettings()
{
  ProxySettings::singletonRef = NULL;

  // remove all unused proxy data again
  for( int i = 0; i < this->proxies.size(); i++)
  {
    IPaddress* ip = this->proxies.back();
    this->proxies.pop_back();
    delete ip;
  }
}



/**
 * load the proxy settings
 * @param root: the root element of the xml elemnts
 */
void ProxySettings::loadProxySettings(const TiXmlElement* root)
{

  LoadParam(root, "max-player", this, ProxySettings, setMaxPlayer);

  LOAD_PARAM_START_CYCLE(root, element);
  {
    element->ToText();
    // PER-PARTICLE-ATTRIBUTES:
    LoadParam(root, "proxy-addr", this, ProxySettings, setProxyAddr);
  }
  LOAD_PARAM_END_CYCLE(element);

}


/**
 * sets the proxy address to
 *  @param proxyAddr: the proxy address
 */
void ProxySettings::setProxyAddr(const std::string& proxyAddr)
{
  IPaddress *ip = new IPaddress;

  SDLNet_ResolveHost( ip, proxyAddr.c_str(), 9999 );

  this->proxies.push_back(ip);
}







