/*!
 * @file peer_info.h
 *  implementation a peer info
 */

#ifndef _PEER_INFO_H
#define _PEER_INFO_H

#include "server_socket.h"
#include "handshake.h"
#include "monitor/connection_monitor.h"

#include <string>

//!< this structure contains informations about the network node
class PeerInfo
{
  public:
    PeerInfo();

    void clear();


    inline bool isMasterServer() { return this->nodeType == NET_MASTER_SERVER; }
    inline bool isProxyServer() { return this->nodeType == NET_PROXY_SERVER_ACTIVE; }
    inline bool isClient() { return this->nodeType == NET_CLIENT; }

    std::string getNodeTypeString();


  public:
    int                 userId;
    int                 nodeType;
    IP                  ip;

    NetworkSocket *     socket;
    Handshake *         handshake;
    ConnectionMonitor * connectionMonitor;

    int                 lastAckedState;
    int                 lastRecvedState;
};



#endif /* _PEER_INFO_H */
