/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner rennerc@ee.ethz.ch
   co-programmer:   Patrick Boenzli  boenzlip@orxonox.ethz.ch

     June 2006: finishing work on the network stream for pps presentation (rennerc@ee.ethz.ch)
     July 2006: some code rearangement and integration of the proxy server mechanism (boenzlip@ee.ethz.ch)
*/


#define DEBUG_MODULE_NETWORK


#include "peer_info.h"


using namespace std;



/**
 * constructor
 */
PeerInfo::PeerInfo()
{
  this->clear();
}


/**
 * clearint and initializing the peer info
 */
void PeerInfo::clear()
{
  this->userId = 0;
  this->nodeType = NET_CLIENT;
  this->socket = NULL;
  this->handshake = NULL;
  this->lastAckedState = 0;
  this->lastRecvedState = 0;
  this->connectionMonitor = NULL;

  this->ip = IP(0,0);
}


std::string PeerInfo::getNodeTypeString()
{
  switch( this->nodeType)
  {
    case NET_CLIENT:
      return std::string("client");
    case NET_PROXY_SERVER_ACTIVE:
      return std::string("proxy server active");
    case NET_PROXY_SERVER_PASSIVE:
      return std::string("proxy server passive");
    case NET_MASTER_SERVER:
      return std::string("master server");
  }

  return std::string("node is uninit");
}
