/*!
 * @file network_socket.h
  *  Main interface for the network module. Manages all the modules

*/

#ifndef _NETWORK_SOCKET
#define _NETWORK_SOCKET

/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "base_object.h"

class NetworkSocket : public BaseObject
{
  public:
    NetworkSocket();
    virtual ~NetworkSocket();

    /**
     * connect to server on host with port port
     * @param host hostname might be xxx.xxx.xxx.xxx or localhost ...
     * @param port port to connect to
     */
    virtual void connectToServer( std::string host, int port ) = 0;

    /**
     * disconnect from server
     */
    virtual void disconnectServer() = 0;

    /**
     * reconnecting to another server by terminating old connection and init a new connection
     */
    virtual void reconnectToServer( std::string host, int port) = 0;

    /**
     * reconnecting to anoter server softly
     */
    virtual void reconnectToServerSoft( std::string host, int port) = 0;

    /**
     * send packet to connected socket. will be recieved as whole packet
     * @param data pointer to data to send
     * @param length lengt of packet to send
     * @return true on success
     */
    virtual bool writePacket(byte * data, int length) = 0;

    /**
     * read a packet sent by another NetworkSocket
     * @param data data will be copied here
     * @param maxLength readPacket will not read more than maxLength
     * @return bytes read. on error less than zero
     */
    virtual int readPacket(byte * data, int maxLength) = 0;

    /**
     * check if socket is ok
     * @return true if socket is ok
     */
    inline bool isOk() { return this->bOk; }

    /** @returns the ip adderess of the destination socket */
    IPaddress getRemoteAddress() { return ip; }


  protected:
    bool              bOk;            //!< check for socket status

    IPaddress         ip;             //!< host,port
};



#endif /* _NETWORK_SOCKET */
