/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "class_list.h"
#include "debug.h"
#include "shell_command.h"

/* include your own header */
#include "network_manager.h"
#include "shared_network_data.h"
#include "network_stream.h"
#include "preferences.h"
#include "network_log.h"
#include "network_game_manager.h"


/* using namespace std is default, this needs to be here */
using namespace std;

SHELL_COMMAND(debug, NetworkManager, debug);


NetworkManager* NetworkManager::singletonRef = NULL;

/**
 *  standard constructor
 */
NetworkManager::NetworkManager()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_MANAGER, "NetworkManager");
  PRINTF(0)("START\n");

  /* initialize the references */
  this->networkStream = NULL;
  this->elapsedTime = 0.0f;


  int port = Preferences::getInstance()->getInt( "network", "telnetport", 0 );

  if ( port > 0 )
    NetworkLog::getInstance()->listen( port );

  PRINTF(0)("NetworkManager created\n");
}


/**
 *  standard deconstructor
 */
NetworkManager::~NetworkManager()
{
  PRINTF(0)("NetworkManager destructor\n");
  if ( this->networkStream )
  {
    delete this->networkStream;
    this->networkStream = NULL;
  }

  NetworkManager::singletonRef = NULL;
}


/**
 *  initializes the network manager
 */
void NetworkManager::initialize()
{
  PRINTF(0)("NetworkManager initzalized\n");
}


/**
 *  shutsdown the network manager
 */
void NetworkManager::shutdown()
{

}


/**
 *  creates a connection from one object to a host
 * @param hostName: the name of the destination host
 */
int NetworkManager::establishConnection(const std::string & name, unsigned int port)
{
  this->networkStream = new NetworkStream( name, port );
  SharedNetworkData::getInstance()->setDefaultSyncStream(this->networkStream);
  this->networkStream->startHandshake();
  return 1;
}


/**
 *  creates a new NetworkStream of server type
 * @param port: number of the TCP port
 */
int NetworkManager::createServer(unsigned int port)
{
  SharedNetworkData::getInstance()->setHostID(0);
  SharedNetworkData::getInstance()->setNodeType(NET_MASTER_SERVER);
  this->networkStream = new NetworkStream(port);
  SharedNetworkData::getInstance()->setDefaultSyncStream(this->networkStream);
  this->networkStream->createNetworkGameManager();
  PRINTF(0)("CREATE SERVER\n");
  SDL_Delay(20);
  return 1;
}


void NetworkManager::connectSynchronizeable(Synchronizeable& sync)
{
  if( this->networkStream)
    this->networkStream->connectSynchronizeable(sync);
}


/**
 *  sync the network
 *  @param dtS: the seceonds elapsed since the last synchronize call
 */
void NetworkManager::synchronize( float dtS)
{
  this->elapsedTime += dtS;
  if( likely(this->elapsedTime < 1.0f / NETWORK_FREQUENCY))
    return;
  this->elapsedTime = 0.0f;

  if ( networkStream )
    networkStream->processData();

  NetworkGameManager::getInstance()->tick( this->elapsedTime );
}



/**
 * debug output
 */
 void NetworkManager::debug()
{
  PRINT(0)("=================Network::debug()=========\n");
  this->networkStream->debug();
  PRINT(0)("===========================================\n");
}
