/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner rennerc@ee.ethz.ch
   co-programmer:   Patrick Boenzli  boenzlip@orxonox.ethz.ch

     June 2006: finishing work on the network stream for pps presentation (rennerc@ee.ethz.ch)
     July 2006: some code rearangement and integration of the proxy server mechanism (boenzlip@ee.ethz.ch)
*/

/*!
 * @file network_manager.h
 *  Main interface for the network module. Manages all the modules
 */

#ifndef _NETDEFS
#define _NETDEFS


#ifdef HAVE_SDL_NET_H
  #include <SDL_net.h>
#else
  #include <SDL/SDL_net.h>
#endif


//!< maximal connectinons for the server
#define NET_MAX_CONNECTIONS 100

//!< the amount of slots used before a proxy server is activated
#define NET_CONNECTION_SATURATION 0.75

//!< network polling frequency
#define NETWORK_FREQUENCY 66


//!< orxonox protocol id
#define _ORXONOX_ID        0xF91337A0
//!< orxonox network version identifier
#define _ORXONOX_VERSION   1


typedef unsigned char byte;


//!< enum indicating the type of the node
typedef enum {
  NET_MASTER_SERVER,
  NET_PROXY_SERVER_ACTIVE,
  NET_PROXY_SERVER_PASSIVE,
  NET_CLIENT,

  NET_NR_TYPES

} NodeType;

//!< enum indicating the type of the network connection (2 protocols supported)
typedef enum ConnectionType {
  NET_UDP = 0,
  NET_TCP
};

//!< the type of the user id (special number never used elsewhere)
typedef enum {
  NET_UID_UNASSIGNED = -1,

  NET_UID_NUMBER
} UidType;

#endif /* _NETWORK_MANAGER */
