/*!
 * @file network_node.h
 *  a class representing a node in the network (this can be a MASTER_SERVER, PROXY_SERVER or a CLIENT
 */

#ifndef _NETWORK_NODE_H
#define _NETWORK_NODE_H

#include "base_object.h"
#include "synchronizeable.h"
#include "peer_info.h"

#include <list>


//!< a class representing a node in the network (this can be a MASTER_SERVER, PROXY_SERVER or a CLIENT
class NetworkNode
{
  public:
    NetworkNode(PeerInfo* pInfo);
    ~NetworkNode();


    void addClient(PeerInfo* node);
    void addActiveProxyServer(PeerInfo* node);
    void addPassiveProxyServer(PeerInfo* node);
    void addMasterServer(PeerInfo* node);

    void removeClient(PeerInfo* node);
    void removeActiveProxyServer(PeerInfo* node);
    void removePassiveProxyServer(PeerInfo* node);
    void removeMasterServer(PeerInfo* node);

    PeerInfo* getClient(int index);
    PeerInfo* getActiveProxyServer(int index);
    PeerInfo* getPassiveProxyServer(int index);
    PeerInfo* getMasterServer(int index);

    /** @returns the number of players */
    inline int getPlayerNumber() { return this->playerNumber; }
    /** @returns the node type of this node */
    inline int getNodeType() { return this->peerInfo->nodeType; }
    /** @returns the peer info of this node */
    inline PeerInfo* getPeerInfo() { return this->peerInfo; }

    void debug(int depth);


  private:
    int                          playerNumber;                 //!< localy direct connected player number
    PeerInfo*                    peerInfo;                     //!< the peer informationa about this node

    /* network nodes directly connected to this node */
    std::list<PeerInfo*>         clientList;                   //!< list of all clients in the network
    std::list<PeerInfo*>         activeProxyServerList;        //!< list of all proxy servers in the network
    std::list<PeerInfo*>         passiveProxyServerList;       //!< list of all proxy servers in the network
    std::list<PeerInfo*>         masterServerList;             //!< list of all master servers in the network (should be 1!! :D)

};

#endif /* _NETWORK_NODE_H */
