/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/


#include "network_node.h"

#include "debug.h"


/**
 * constructor
 */
NetworkNode::NetworkNode(PeerInfo* pInfo)
{
  this->playerNumber = 0;
  this->peerInfo = pInfo;
}


/**
 * deconstructor
 */
NetworkNode::~NetworkNode()
{}


/**
 * adds a client
 */
void NetworkNode::addClient(PeerInfo* node)
{
  this->clientList.push_back(node);
  this->playerNumber++;
}

/**
 * adds a proxy server
 */
void NetworkNode::addActiveProxyServer(PeerInfo* node)
{
  this->activeProxyServerList.push_back(node);
  this->playerNumber++;
}

/**
 * adds a proxy server
 */
void NetworkNode::addPassiveProxyServer(PeerInfo* node)
{
  this->passiveProxyServerList.push_back(node);
}

/**
 * adds a master server
 */
void NetworkNode::addMasterServer(PeerInfo* node)
{
  this->masterServerList.push_back(node);
  this->playerNumber++;
}

/**
 * removes a client
 */
void NetworkNode::removeClient(PeerInfo* node)
{
  std::list<PeerInfo*>::iterator it = this->clientList.begin();
  for(; it != this->clientList.end(); it++)
  {
    if( *it == node)
    {
      this->clientList.erase(it);
      this->playerNumber--;
      return;
    }
  }

  PRINTF(2)("Could not remove client from the list, very strange...");
}

/**
 * removes a proxy server
 */
void NetworkNode::removeActiveProxyServer(PeerInfo* node)
{
  std::list<PeerInfo*>::iterator it = this->activeProxyServerList.begin();
  for(; it != this->activeProxyServerList.end(); it++)
  {
    if( *it == node)
    {
      this->activeProxyServerList.erase(it);
      this->playerNumber--;
      return;
    }
  }

  PRINTF(2)("Could not remove proxy server from the list, very strange...");
}

/**
 * removes a proxy server
 */
void NetworkNode::removePassiveProxyServer(PeerInfo* node)
{
  std::list<PeerInfo*>::iterator it = this->passiveProxyServerList.begin();
  for(; it != this->passiveProxyServerList.end(); it++)
  {
    if( *it == node)
    {
      this->passiveProxyServerList.erase(it);
      return;
    }
  }

  PRINTF(2)("Could not remove proxy server from the list, very strange...");
}

/**
 * removes a master server
 */
void NetworkNode::removeMasterServer(PeerInfo* node)
{
  std::list<PeerInfo*>::iterator it = this->masterServerList.begin();
  for(; it != this->masterServerList.end(); it++)
  {
    if( *it == node)
    {
      this->masterServerList.erase(it);
      this->playerNumber--;
      return;
    }
  }

  PRINTF(2)("Could not remove client from the list, very strange...");
}


/**
 * @param index index to the client
 * @return the client in the list or NULL if none
 */
PeerInfo* NetworkNode::getClient(int index)
{
  if( this->clientList.size() < index)
    return NULL;

  std::list<PeerInfo*>::iterator it = this->clientList.begin();
  for(int i = 0; it != this->clientList.end(); it++, i++)
  {
  if( i == index)
    return (*it);
  }

  return NULL;
}


/**
 * @param index index to the client
 * @return the active proxy server in the list or NULL if none
 */
PeerInfo* NetworkNode::getActiveProxyServer(int index)
{
  if( this->activeProxyServerList.size() < index)
    return NULL;

  std::list<PeerInfo*>::iterator it = this->activeProxyServerList.begin();
  for(int i = 0; it != this->activeProxyServerList.end(); it++, i++)
  {
    if( i == index)
      return (*it);
  }

  return NULL;
}


/**
 * @param index index to the client
 * @return the passive proxy server in the list or NULL if none
 */
PeerInfo* NetworkNode::getPassiveProxyServer(int index)
{
  if( this->passiveProxyServerList.size() < index)
    return NULL;

  std::list<PeerInfo*>::iterator it = this->passiveProxyServerList.begin();
  for(int i = 0; it != this->passiveProxyServerList.end(); it++, i++)
  {
    if( i == index)
      return (*it);
  }

  return NULL;
}


/**
 * @param index index to the client
 * @return the master server in the list or NULL if none
 */
PeerInfo* NetworkNode::getMasterServer(int index)
{
  if( this->masterServerList.size() < index)
    return NULL;

  std::list<PeerInfo*>::iterator it = this->masterServerList.begin();
  for(int i = 0; it != this->masterServerList.end(); it++, i++)
  {
    if( i == index)
      return (*it);
  }

  return NULL;
}


/**
 * debug function
 * @param depth: depth in the tree
 */
void NetworkNode::debug(int depth)
{
  PRINT(0)(" = %s\n", this->peerInfo->getNodeTypeString().c_str());

  PRINT(0)("    master servers: %i\n", this->masterServerList.size());
  std::list<PeerInfo*>::iterator it = this->masterServerList.begin();
  for(; it != this->masterServerList.end(); it++)
  {
    IP* ip = &(*it)->ip;
    PRINT(0)("     - ms, id: %i (%s)\n", (*it)->userId, ip->ipString().c_str());
  }

  PRINT(0)("    proxy servers active: %i\n", this->activeProxyServerList.size());
  it = this->activeProxyServerList.begin();
  for(; it != this->activeProxyServerList.end(); it++)
  {
    IP* ip = &(*it)->ip;
    PRINT(0)("     - ps-a, id: %i (%s)\n", (*it)->userId, ip->ipString().c_str());
  }

  PRINT(0)("    proxy servers passive: %i\n", this->passiveProxyServerList.size());
  it = this->passiveProxyServerList.begin();
  for(; it != this->passiveProxyServerList.end(); it++)
  {
    IP* ip = &(*it)->ip;
    PRINT(0)("     - ps-p, id: %i (%s)\n", (*it)->userId, ip->ipString().c_str());
  }

  PRINT(0)("    clients: %i\n", this->clientList.size());
  it = this->clientList.begin();
  for(; it != this->clientList.end(); it++)
  {
    IP* ip = &(*it)->ip;
    PRINT(0)("     - client, id: %i (%s)\n", (*it)->userId, ip->ipString().c_str());
  }
}

