/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner (rennerc@ee.ethz.ch)
   co-programmer: Patirck Boenzli (boenzlip@orxonox.ethz.ch)
*/


#define DEBUG_MODULE_NETWORK

#include "handshake.h"

#include <cassert>
#include "debug.h"





 Handshake::Handshake( int nodeType, int clientId, int networkGameManagerId, int messageManagerId )
  : Synchronizeable()
{
  /* set the class id for the base object */
  this->setClassID(CL_HANDSHAKE, "Handshake");

  // register all variable handlers
  orxId_handler = registerVarId( new SynchronizeableInt( &localState.orxId, &remoteState.orxId, "orxonoxId", PERMISSION_ALL ) );
  version_handler = registerVarId( new SynchronizeableInt( &localState.version, &remoteState.version, "version", PERMISSION_ALL ) );
  netManId_handler = registerVarId( new SynchronizeableInt( &localState.networkManagerId, &remoteState.networkManagerId, "networkManagerId", PERMISSION_ALL ) );
  msgManId_handler = registerVarId( new SynchronizeableInt( &localState.messageManagerId, &remoteState.messageManagerId, "messageManagerId", PERMISSION_ALL ) );
  hostId_handler = registerVarId( new SynchronizeableInt( &localState.hostId, &remoteState.hostId, "hostId", PERMISSION_ALL ) );
  completed_handler = registerVarId( new SynchronizeableInt( &localState.completed, &remoteState.completed, "completed", PERMISSION_ALL ) );
  error_handler = registerVarId( new SynchronizeableInt( &localState.error, &remoteState.error, "error", PERMISSION_ALL ) );
  errorString_handler = registerVarId( new SynchronizeableString( &localState.errorString, &remoteState.errorString, "errorString", PERMISSION_ALL ) );

  this->nodeTypeHandler = registerVarId( new SynchronizeableInt( &localState.nodeType, &remoteState.nodeType, "nodeType", PERMISSION_ALL ) );

  candel_id = registerVarId( new SynchronizeableInt( &localState.canDel, &remoteState.canDel, "canDel", PERMISSION_ALL ) );

  registerVar( new SynchronizeableString( &localState.preferedNickName, &remoteState.preferedNickName, "preferedNickName", PERMISSION_ALL ) );
  // now synchronize only two of the available proxy server addresses
  registerVar( new SynchronizeableIP( &localState.proxy1, &remoteState.proxy1, "proxy server 1", PERMISSION_ALL ) );
  registerVar( new SynchronizeableIP( &localState.proxy2, &remoteState.proxy1, "proxy server 2", PERMISSION_ALL ) );

  // init the local state
  localState.completed = 0;
  localState.error = 0;
  localState.errorString = "";
  localState.hostId = clientId;
  localState.networkManagerId = networkGameManagerId;
  this->localState.messageManagerId = messageManagerId;
  localState.orxId = _ORXONOX_ID;
  localState.version = _ORXONOX_VERSION;
  localState.nodeType = nodeType;
  localState.canDel = 0;
  localState.redirectProxy = 0;
  localState.proxy1 = IP(0, 0);
  localState.proxy2 = IP (0, 0);


  // init the remote state
  remoteState.completed = 0;
  remoteState.error = 0;
  remoteState.errorString = "";
  remoteState.hostId = -1;
  remoteState.networkManagerId = -1;
  remoteState.messageManagerId = -1;
  remoteState.orxId = 0;
  remoteState.version = 0;
  remoteState.nodeType = NET_CLIENT;
  remoteState.canDel = 0;
  remoteState.redirectProxy = 0;
  remoteState.proxy1 = IP(0, 0);
  remoteState.proxy2 = IP(0, 0);

  // activate the synchronization process
  this->setSynchronized(true);
  PRINTF(0)("Handshake created clientId = %d\n", clientId);
}


/**
 * handler for changes in synced vars
 * @param id id's which have changed
 */
void Handshake::varChangeHandler( std::list< int > & id )
{
  for ( std::list<int>::iterator it = id.begin(); it != id.end(); it++ )
  {
    // orxonox id handler
    if ( *it == this->orxId_handler )
    {
      if ( remoteState.orxId != _ORXONOX_ID )
      {
        localState.error = 1;
        localState.completed = 1;
        localState.errorString = "Seems not to be orxonox!";
        continue;
      }
    }

    // orxonox version handler
    if ( *it == this->version_handler )
    {
      if ( remoteState.version != _ORXONOX_VERSION )
      {
        localState.error = 2;
        localState.completed = 1;
        localState.errorString = "Versions of server and client do not match!";
        continue;
      }
    }

    // node type handler: for each node type there is a specific action to be taken
    if ( *it == this->nodeTypeHandler)
    {
      if ( remoteState.nodeType == NET_MASTER_SERVER )
      {
        continue;
      }
      else if( remoteState.nodeType == NET_PROXY_SERVER_ACTIVE)
      {
        continue;
      }
      else if( remoteState.nodeType == NET_CLIENT)
      {
        continue;
      }
    }

    // cancel
    if ( *it == candel_id )
    {
      PRINTF(0)("handshake finished candel changed\n");
    }

  }

  // handshake completed
  if ( remoteState.orxId == _ORXONOX_ID &&
       remoteState.version == _ORXONOX_VERSION )
  {
    localState.completed = 1;
  }
}

